/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.configuration;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.rendering.internal.configuration.XWikiRenderingConfiguration;

@Component
@Singleton
public class DefaultXWikiRenderingConfiguration
implements XWikiRenderingConfiguration {
    private static final String PREFIX = "rendering.";
    private static final String DEFAULT_LINK_LABEL_FORMAT = "%p";
    @Inject
    private ConfigurationSource configuration;
    @Inject
    private ComponentManager componentManager;

    public String getLinkLabelFormat() {
        return (String)this.configuration.getProperty("rendering.linkLabelFormat", (Object)DEFAULT_LINK_LABEL_FORMAT);
    }

    @Override
    public int getImageWidthLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageWidthLimit", (Object)-1);
    }

    @Override
    public int getImageHeightLimit() {
        return (Integer)this.configuration.getProperty("rendering.imageHeightLimit", (Object)-1);
    }

    @Override
    public boolean isImageDimensionsIncludedInImageURL() {
        return (Boolean)this.configuration.getProperty("rendering.imageDimensionsIncludedInImageURL", (Object)true);
    }

    public Properties getInterWikiDefinitions() {
        return (Properties)this.configuration.getProperty("rendering.interWikiDefinitions", Properties.class);
    }

    public List<String> getTransformationNames() {
        return (List)this.configuration.getProperty("rendering.transformations", Arrays.asList("macro", "icon"));
    }
}

