/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.wiki;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.internal.configuration.XWikiRenderingConfiguration;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Singleton
public class XWikiWikiModel
implements WikiModel {
    private static final String PIXELS = "px";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    @Inject
    private XWikiRenderingConfiguration xwikiRenderingConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> currentAttachmentReferenceResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    private final CSSOMParser cssParser = new CSSOMParser((Parser)new SACParserCSS21());

    public String getLinkURL(ResourceReference linkReference) {
        return this.documentAccessBridge.getAttachmentURL(this.resolveAttachmentReference(linkReference), linkReference.getParameter("queryString"), true);
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        if (imageReference.getType().equals((Object)ResourceType.ICON)) {
            return this.skinAccessBridge.getIconURL(imageReference.getReference());
        }
        String url = this.getLinkURL(imageReference);
        if (!this.xwikiRenderingConfiguration.isImageDimensionsIncludedInImageURL()) {
            return url;
        }
        StringBuilder queryString = this.getImageURLQueryString(parameters);
        if (queryString.length() == 0) {
            return url;
        }
        int insertionPoint = url.lastIndexOf(35);
        if (insertionPoint < 0) {
            insertionPoint = url.length();
        }
        if (url.lastIndexOf(63, insertionPoint) < 0) {
            queryString.setCharAt(0, '?');
        }
        return new StringBuilder(url).insert(insertionPoint, queryString).toString();
    }

    public boolean isDocumentAvailable(ResourceReference documentResourceReference) {
        DocumentReference documentReference = this.resolveDocumentReference(documentResourceReference);
        return this.documentAccessBridge.exists(documentReference);
    }

    public String getDocumentViewURL(ResourceReference documentResourceReference) {
        DocumentReference documentReference = this.resolveDocumentReference(documentResourceReference);
        return this.documentAccessBridge.getDocumentURL(documentReference, "view", documentResourceReference.getParameter("queryString"), documentResourceReference.getParameter("anchor"));
    }

    public String getDocumentEditURL(ResourceReference documentResourceReference) {
        DocumentReference reference;
        String modifiedQueryString = documentResourceReference.getParameter("queryString");
        if (StringUtils.isBlank((CharSequence)modifiedQueryString) && (reference = this.documentAccessBridge.getCurrentDocumentReference()) != null) {
            try {
                modifiedQueryString = "parent=" + URLEncoder.encode((String)this.compactEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL encode [" + (String)this.compactEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]) + "] using UTF-8.", e);
            }
        }
        DocumentReference documentReference = this.resolveDocumentReference(documentResourceReference);
        return this.documentAccessBridge.getDocumentURL(documentReference, "create", modifiedQueryString, documentResourceReference.getParameter("anchor"));
    }

    private DocumentReference resolveDocumentReference(ResourceReference documentResourceReference) {
        DocumentReference documentReference;
        if (!documentResourceReference.getBaseReferences().isEmpty()) {
            DocumentReference baseReference = this.resolveBaseReference(documentResourceReference.getBaseReferences());
            documentReference = this.currentDocumentReferenceResolver.resolve((Object)documentResourceReference.getReference(), new Object[]{baseReference});
        } else {
            documentReference = this.currentDocumentReferenceResolver.resolve((Object)documentResourceReference.getReference(), new Object[0]);
        }
        return documentReference;
    }

    private DocumentReference resolveBaseReference(List<String> baseReferences) {
        DocumentReference resolvedBaseReference = null;
        for (String baseReference : baseReferences) {
            if (resolvedBaseReference != null) {
                resolvedBaseReference = this.currentDocumentReferenceResolver.resolve((Object)baseReference, new Object[]{resolvedBaseReference});
                continue;
            }
            resolvedBaseReference = this.currentDocumentReferenceResolver.resolve((Object)baseReference, new Object[0]);
        }
        return resolvedBaseReference;
    }

    private AttachmentReference resolveAttachmentReference(ResourceReference attachmentResourceReference) {
        AttachmentReference attachmentReference;
        if (!attachmentResourceReference.getBaseReferences().isEmpty()) {
            DocumentReference baseReference = this.resolveBaseReference(attachmentResourceReference.getBaseReferences());
            attachmentReference = this.currentAttachmentReferenceResolver.resolve((Object)attachmentResourceReference.getReference(), new Object[]{baseReference});
        } else {
            attachmentReference = this.currentAttachmentReferenceResolver.resolve((Object)attachmentResourceReference.getReference(), new Object[0]);
        }
        return attachmentReference;
    }

    private String getImageDimension(String dimension, Map<String, String> imageParameters) {
        String value = null;
        String style = imageParameters.get("style");
        if (StringUtils.isNotBlank((CharSequence)style)) {
            try {
                CSSStyleDeclaration sd = this.cssParser.parseStyleDeclaration(new InputSource((Reader)new StringReader(style)));
                value = sd.getPropertyValue(dimension);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank(value)) {
            value = imageParameters.get(dimension);
        }
        return value;
    }

    private StringBuilder getImageURLQueryString(Map<String, String> imageParameters) {
        String width = StringUtils.chomp((String)this.getImageDimension(WIDTH, imageParameters), (String)PIXELS);
        String height = StringUtils.chomp((String)this.getImageDimension(HEIGHT, imageParameters), (String)PIXELS);
        boolean useHeight = StringUtils.isNotEmpty((CharSequence)height) && StringUtils.isNumeric((CharSequence)height);
        StringBuilder queryString = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)width) || !StringUtils.isNumeric((CharSequence)width)) {
            if (useHeight) {
                queryString.append('&').append(HEIGHT).append('=').append(height);
            } else {
                int heightLimit;
                int widthLimit = this.xwikiRenderingConfiguration.getImageWidthLimit();
                if (widthLimit > 0) {
                    queryString.append('&').append(WIDTH).append('=').append(widthLimit);
                }
                if ((heightLimit = this.xwikiRenderingConfiguration.getImageHeightLimit()) > 0) {
                    queryString.append('&').append(HEIGHT).append('=').append(heightLimit);
                }
                if (widthLimit > 0 && heightLimit > 0) {
                    queryString.append("&keepAspectRatio=").append(true);
                }
            }
        } else {
            queryString.append('&').append(WIDTH).append('=').append(width);
            if (useHeight) {
                queryString.append('&').append(HEIGHT).append('=').append(height);
            }
        }
        return queryString;
    }
}

