/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.internal.resolver.AbstractResourceReferenceEntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="doc")
@Singleton
public class DocumentResourceReferenceEntityReferenceResolver
extends AbstractResourceReferenceEntityReferenceResolver {
    @Inject
    private DocumentReferenceResolver<String> defaultStringDocumentReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeReferenceResolver;

    public DocumentResourceReferenceEntityReferenceResolver() {
        super(ResourceType.DOCUMENT);
    }

    @Override
    protected EntityReference resolveTyped(ResourceReference resourceReference, EntityReference baseReference) {
        return this.defaultStringDocumentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{baseReference});
    }

    @Override
    protected EntityReference resolveUntyped(ResourceReference resourceReference, EntityReference baseReference) {
        if (StringUtils.isEmpty((CharSequence)resourceReference.getReference())) {
            return this.resolveTyped(resourceReference, baseReference);
        }
        EntityReference relativeReference = this.relativeReferenceResolver.resolve((Object)resourceReference.getReference(), EntityType.DOCUMENT, new Object[0]);
        DocumentReference reference = this.defaultStringDocumentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{baseReference});
        reference = this.resolveDocumentReference(relativeReference, reference, baseReference);
        return reference;
    }
}

