/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;

@Unstable
public abstract class AbstractResourceReference
implements ResourceReference {
    private Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
    private ResourceType type;

    @Override
    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    @Override
    public void addParameter(String name, String value) {
        List<String> list = this.parameters.get(name);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (value != null) {
            list.add(value);
        }
        this.parameters.put(name, list);
    }

    @Override
    public Map<String, List<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public String getParameterValue(String name) {
        String result = null;
        List<String> list = this.parameters.get(name);
        if (list != null) {
            result = list.get(0);
        }
        return result;
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("type", (Object)(this.getType() == null ? null : this.getType()));
        builder.append("parameters", this.getParameters());
        return builder.toString();
    }
}

