/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.servlet;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.container.Container;
import org.xwiki.container.servlet.ServletContainerException;
import org.xwiki.container.servlet.ServletContainerInitializer;
import org.xwiki.context.Execution;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceReferenceHandlerManager;
import org.xwiki.resource.ResourceReferenceResolver;
import org.xwiki.resource.ResourceType;
import org.xwiki.url.ExtendedURL;

public class ResourceReferenceHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ComponentManager rootComponentManager;

    public void init() throws ServletException {
        super.init();
        this.rootComponentManager = (ComponentManager)this.getServletContext().getAttribute(ComponentManager.class.getName());
    }

    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        try {
            this.initializeContainerComponent(httpRequest, httpResponse);
            this.handleResourceReference(this.getResourceReference(httpRequest));
        }
        finally {
            this.cleanupComponents();
        }
    }

    private ResourceReference getResourceReference(HttpServletRequest httpRequest) throws ServletException {
        ResourceType resourceType = (ResourceType)httpRequest.getAttribute("resourceType");
        ExtendedURL extendedURL = (ExtendedURL)httpRequest.getAttribute("resourceURL");
        ResourceReferenceResolver<ExtendedURL> urlResolver = this.getResourceReferenceResolver();
        try {
            return urlResolver.resolve((Object)extendedURL, resourceType, Collections.emptyMap());
        }
        catch (Exception e) {
            throw new ServletException(String.format("Failed to extract the Resource Reference from the URL [%s]", extendedURL.getWrappedURL()), (Throwable)e);
        }
    }

    private ResourceReferenceResolver<ExtendedURL> getResourceReferenceResolver() throws ServletException {
        ResourceReferenceResolver urlResolver;
        try {
            DefaultParameterizedType role = new DefaultParameterizedType(null, ResourceReferenceResolver.class, new Type[]{ExtendedURL.class});
            urlResolver = (ResourceReferenceResolver)this.rootComponentManager.getInstance((Type)role);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate an ExtendedURL Resource Reference Resolver component", (Throwable)e);
        }
        return urlResolver;
    }

    private void initializeContainerComponent(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException {
        ServletContainerInitializer containerInitializer;
        try {
            containerInitializer = (ServletContainerInitializer)this.rootComponentManager.getInstance(ServletContainerInitializer.class);
        }
        catch (Exception e) {
            throw new ServletException("Failed to locate a ServletContainerInitializer component", (Throwable)e);
        }
        try {
            containerInitializer.initializeRequest(httpRequest);
            containerInitializer.initializeResponse(httpResponse);
            containerInitializer.initializeSession(httpRequest);
        }
        catch (ServletContainerException e) {
            throw new ServletException("Failed to initialize Request/Response or Session", (Throwable)e);
        }
    }

    private void handleResourceReference(ResourceReference resourceReference) throws ServletException {
        ResourceReferenceHandlerManager resourceReferenceHandlerManager;
        try {
            DefaultParameterizedType role = new DefaultParameterizedType(null, ResourceReferenceHandlerManager.class, new Type[]{ResourceType.class});
            resourceReferenceHandlerManager = (ResourceReferenceHandlerManager)this.rootComponentManager.getInstance((Type)role);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate a Resource Reference Handler Manager component", (Throwable)e);
        }
        try {
            resourceReferenceHandlerManager.handle(resourceReference);
        }
        catch (ResourceReferenceHandlerException e) {
            throw new ServletException(String.format("Failed to handle Resource Reference [%s]", resourceReference), (Throwable)e);
        }
    }

    private void cleanupComponents() throws ServletException {
        Execution execution;
        Container container;
        try {
            container = (Container)this.rootComponentManager.getInstance(Container.class);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate a Container component", (Throwable)e);
        }
        try {
            execution = (Execution)this.rootComponentManager.getInstance(Execution.class);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Failed to locate a Execution component", (Throwable)e);
        }
        container.removeRequest();
        container.removeResponse();
        container.removeSession();
        execution.removeContext();
    }
}

