/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.restlet.Context;
import org.restlet.security.SecretVerifier;
import org.securityfilter.filter.SecurityRequestWrapper;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.rest.internal.Utils;
import org.xwiki.security.authentication.api.AuthenticationFailureManager;

public class XWikiSecretVerifier
extends SecretVerifier {
    private ComponentManager componentManager;
    private Context context;

    public XWikiSecretVerifier(Context context, ComponentManager manager) {
        this.context = context;
        this.componentManager = manager;
    }

    public int verify(String identifier, char[] secret) throws IllegalArgumentException {
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        XWiki xwiki = Utils.getXWiki(this.componentManager);
        SecurityRequestWrapper securityRequestWrapper = new SecurityRequestWrapper((HttpServletRequest)xwikiContext.getRequest(), null, null, "CHALLENGE");
        try {
            Principal principal;
            AuthenticationFailureManager authenticationFailureManager = (AuthenticationFailureManager)this.componentManager.getInstance(AuthenticationFailureManager.class);
            Principal principal2 = principal = secret == null ? null : xwiki.getAuthService().authenticate(identifier, new String(secret), xwikiContext);
            if (principal != null && authenticationFailureManager.validateForm(identifier, securityRequestWrapper)) {
                authenticationFailureManager.resetAuthenticationFailureCounter(identifier);
                String xwikiUser = principal.getName();
                xwikiContext.setUser(xwikiUser);
                this.context.getLogger().log(Level.FINE, String.format("Authenticated as '%s'.", identifier));
                return 4;
            }
            authenticationFailureManager.recordAuthenticationFailure(identifier);
            if (principal != null) {
                ContextualLocalizationManager contextualLocalizationManager = (ContextualLocalizationManager)this.componentManager.getInstance(ContextualLocalizationManager.class);
                String responseMessage = contextualLocalizationManager.getTranslation("security.authentication.rest.blockedError").toString();
                XWikiResponse response = xwikiContext.getResponse();
                response.sendError(403, responseMessage);
            }
        }
        catch (XWikiException | IOException | ComponentLookupException e) {
            this.context.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
        }
        this.context.getLogger().log(Level.WARNING, String.format("Cannot authenticate '%s'.", identifier));
        return -1;
    }
}

