/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.api.Document;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseAttachmentsResource;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.attachments.AttachmentsResourceImpl")
public class AttachmentsResourceImpl
extends BaseAttachmentsResource
implements AttachmentsResource {
    private static final String NAME = "name";
    @Inject
    private ContextualAuthorizationManager authorization;

    public Attachments getAttachments(String wiki, String spaces, String page, Integer offset, Integer limit, Boolean withPrettyNames, String name, String author, String fileTypes) throws XWikiRestException {
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put(NAME, name);
        filters.put("author", author);
        filters.put("fileTypes", fileTypes);
        return super.getAttachments((EntityReference)new DocumentReference(wiki, this.parseSpaceSegments(spaces), page), filters, offset, limit, withPrettyNames);
    }

    public Response addAttachment(String wikiName, String spaceName, String pageName, Multipart multipart, Boolean withPrettyNames, Boolean createPage) throws XWikiRestException {
        try {
            List<String> spaces = this.parseSpaceSegments(spaceName);
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaces, pageName, null, null, createPage == false, true);
            Document doc = documentInfo.getDocument();
            if (!this.authorization.hasAccess(Right.EDIT, (EntityReference)doc.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            ImmutablePair<String, InputStream> file = this.getFile(multipart);
            if (file.getKey() == null || file.getValue() == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAndRetrieveAttachment(doc, (String)file.getKey(), (InputStream)file.getValue(), withPrettyNames);
            if (attachmentInfo.isAlreadyExisting()) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
            }
            return Response.created((URI)Utils.createURI(this.uriInfo.getBaseUri(), AttachmentResource.class, wikiName, spaces, pageName, file.getKey())).entity((Object)attachmentInfo.getAttachment()).build();
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    private ImmutablePair<String, InputStream> getFile(Multipart multipart) throws MessagingException, IOException {
        String originalFileName = null;
        InputStream inputStream = null;
        String overwritingFileName = null;
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            if (!"form-data".equalsIgnoreCase(bodyPart.getDisposition())) continue;
            if (bodyPart.getFileName() != null) {
                originalFileName = bodyPart.getFileName();
                inputStream = bodyPart.getInputStream();
                continue;
            }
            ContentDisposition contentDisposition = new ContentDisposition(bodyPart.getHeader("Content-Disposition")[0]);
            String fieldName = contentDisposition.getParameter(NAME);
            if (!"filename".equals(fieldName)) continue;
            overwritingFileName = IOUtils.toString((InputStream)bodyPart.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        String attachmentName = overwritingFileName != null ? overwritingFileName : originalFileName;
        return new ImmutablePair(attachmentName, inputStream);
    }
}

