/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.objects.classes.ListClass;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.icon.IconManager;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.classes.AbstractListClassPropertyValuesProvider;
import org.xwiki.rest.internal.resources.classes.SplitValueQueryFilter;
import org.xwiki.rest.model.jaxb.PropertyValue;
import org.xwiki.rest.model.jaxb.PropertyValues;

public abstract class AbstractDocumentListClassPropertyValuesProvider<T extends ListClass>
extends AbstractListClassPropertyValuesProvider<T> {
    @Inject
    protected Logger logger;
    @Inject
    protected IconManager iconManager;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactSerializer;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public PropertyValue getValue(ClassPropertyReference propertyReference, Object rawValue) throws XWikiRestException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String reference = "";
        if (rawValue != null) {
            reference = rawValue.toString();
        }
        if (StringUtils.isEmpty((CharSequence)reference)) {
            return null;
        }
        DocumentReference documentReference = this.documentReferenceResolver.resolve((Object)reference, new Object[]{propertyReference});
        PropertyValue propertyValue = null;
        if (xcontext.getWiki().exists(documentReference, xcontext)) {
            propertyValue = super.getValue(propertyReference, documentReference);
        }
        if (propertyValue == null) {
            propertyValue = new PropertyValue();
        }
        propertyValue.setValue((Object)reference);
        return propertyValue;
    }

    protected abstract Map<String, Object> getIcon(DocumentReference var1);

    @Override
    protected PropertyValues getUsedValues(T propertyDefinition, int limit, String filter) throws QueryException {
        Query query = this.usedValuesQueryBuilder.build(propertyDefinition);
        query.getFilters().clear();
        if (propertyDefinition.isMultiSelect() && !propertyDefinition.isRelationalStorage()) {
            query.addFilter((QueryFilter)new SplitValueQueryFilter(propertyDefinition.getSeparators(), limit, filter));
        }
        query.addFilter(this.documentFilter);
        query.addFilter(this.viewableFilter);
        return this.getValues(query, limit, filter, propertyDefinition);
    }

    @Override
    protected PropertyValue getValueFromQueryResult(Object result, T propertyDefinition) {
        PropertyValue value = super.getValueFromQueryResult(result, propertyDefinition);
        if (value != null && value.getValue() instanceof DocumentReference) {
            DocumentReference documentReference = (DocumentReference)value.getValue();
            WikiReference wikiReference = propertyDefinition.getOwnerDocument().getDocumentReference().getWikiReference();
            value.setValue(this.compactSerializer.serialize((EntityReference)documentReference, new Object[]{wikiReference}));
            value.getMetaData().put("label", this.getLabel(documentReference, value.getMetaData().get("label")));
            value.getMetaData().put("icon", this.getIcon(documentReference));
            value.getMetaData().put("url", this.getURL(documentReference));
            value.getMetaData().put("hint", this.getHint(documentReference));
        }
        return value;
    }

    protected String getLabel(DocumentReference documentReference, Object currentLabel) {
        String label;
        String string = label = currentLabel == null ? "" : currentLabel.toString().trim();
        if (label.isEmpty()) {
            label = "WebHome".equals(documentReference.getName()) ? documentReference.getParent().getName() : documentReference.getName();
        }
        return label;
    }

    protected String getURL(DocumentReference documentReference) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.getWiki().getURL((EntityReference)documentReference, xcontext);
    }

    protected String getHint(DocumentReference documentReference) {
        return null;
    }
}

