/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.api.Document;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.pages.PageChildrenResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.pages.PageChildrenResourceImpl")
public class PageChildrenResourceImpl
extends XWikiResource
implements PageChildrenResource {
    public Pages getPageChildren(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Pages pages = this.objectFactory.createPages();
            String queryString = "select distinct doc.fullName from XWikiDocument as doc where doc.parent = :parent order by doc.fullName asc";
            List childPageFullNames = this.queryManager.createQuery(queryString, "xwql").bindValue("parent", (Object)doc.getFullName()).setOffset(start.intValue()).setLimit(number.intValue()).execute();
            for (String childPageFullName : childPageFullNames) {
                String pageId = Utils.getPageId(wikiName, childPageFullName);
                if (!Utils.getXWikiApi(this.componentManager).exists(pageId)) {
                    this.getLogger().warn("Page [{}] appears to be in space [{}] but no information is available.", (Object)pageName, (Object)spaceName);
                    continue;
                }
                Document childDoc = Utils.getXWikiApi(this.componentManager).getDocument(pageId);
                if (childDoc == null) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), childDoc, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            return pages;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

