/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.url;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.url.ParametrizedRestURLGenerator;

public abstract class AbstractParametrizedRestURLGenerator<T>
implements ParametrizedRestURLGenerator<T> {
    @Inject
    protected Provider<XWikiContext> contextProvider;

    protected URI getBaseURI() throws XWikiRestException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWiki xwiki = context.getWiki();
            StringBuilder url = new StringBuilder();
            url.append(context.getURLFactory().getServerURL(context));
            url.append('/');
            String webAppPath = xwiki.getWebAppPath(context);
            if (!webAppPath.equals("/")) {
                url.append(webAppPath);
            }
            url.append("rest");
            return new URI(url.toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new XWikiRestException("Failed to generate a proper base URI.", (Throwable)e);
        }
    }

    public abstract URL getURL(T var1) throws XWikiRestException;
}

