/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rest.XWikiRestComponent;

@Component(roles={ObjectFactory.class})
@Singleton
public class ComponentsObjectFactory
implements ObjectFactory {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Execution execution;

    public <T> T getInstance(Class<T> clazz) throws InstantiateException {
        try {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            XWikiRestComponent component = (XWikiRestComponent)componentManager.getInstance(XWikiRestComponent.class, clazz.getName());
            ComponentDescriptor componentDescriptor = componentManager.getComponentDescriptor(XWikiRestComponent.class, clazz.getName());
            ExecutionContext executionContext = this.execution.getContext();
            ArrayList<XWikiRestComponent> releasableComponentReferences = (ArrayList<XWikiRestComponent>)executionContext.getProperty("rest.releasableComponentReferences");
            if (releasableComponentReferences == null) {
                releasableComponentReferences = new ArrayList<XWikiRestComponent>();
                executionContext.setProperty("rest.releasableComponentReferences", releasableComponentReferences);
            }
            if (componentDescriptor.getInstantiationStrategy() == ComponentInstantiationStrategy.PER_LOOKUP) {
                releasableComponentReferences.add(component);
            }
            return (T)component;
        }
        catch (ComponentLookupException e) {
            throw new InstantiateException((Throwable)e);
        }
    }
}

