/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.xstream.internal.SafeXStream;

@Component(roles={JAXBConverter.class})
@Singleton
public class JAXBConverter
implements Initializable {
    private static final Set<Class<?>> JAXB_COMPATIBLES_CLASSES = new HashSet<Class>(Arrays.asList(String.class, BigInteger.class, Integer.TYPE, Long.TYPE, Short.TYPE, BigDecimal.class, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.TYPE, QName.class, XMLGregorianCalendar.class, byte[].class, byte[].class, Duration.class, Calendar.class, Date.class, URI.class, Image.class, DataHandler.class, Source.class, UUID.class));
    @Inject
    private SafeXStream xstream;
    private DocumentBuilderFactory dbFactory;

    public void initialize() throws InitializationException {
        this.dbFactory = DocumentBuilderFactory.newInstance();
    }

    public boolean isSupported(Class<?> clazz) {
        return JAXB_COMPATIBLES_CLASSES.contains(clazz);
    }

    public Object serializeAny(Object value) throws ParserConfigurationException {
        if (value == null || this.isSupported(value.getClass())) {
            return value;
        }
        DocumentBuilder dBuilder = this.dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElement("rest");
        DomWriter writer = new DomWriter(rootElement);
        this.xstream.marshal(value, (HierarchicalStreamWriter)writer);
        return rootElement;
    }

    public Object unserializeAny(Object any) {
        Object value = any;
        if (any instanceof Element) {
            Element valueElement = (Element)any;
            if (valueElement.hasChildNodes()) {
                NodeList children = valueElement.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    DomReader reader = new DomReader((Element)child);
                    return this.xstream.unmarshal((HierarchicalStreamReader)reader);
                }
            } else {
                value = null;
            }
        }
        return value;
    }
}

