/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import javax.inject.Inject;
import javax.ws.rs.core.Application;
import org.restlet.Restlet;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.routing.Router;
import org.restlet.security.Verifier;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rest.internal.XWikiAuthentication;
import org.xwiki.rest.internal.XWikiSecretVerifier;
import org.xwiki.rest.internal.XWikiSetupCleanupFilter;
import org.xwiki.rest.internal.resources.BrowserAuthenticationResource;

@Component(roles={JaxRsApplication.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiRestletJaxRsApplication
extends JaxRsApplication
implements Initializable {
    @Inject
    private Application jaxrsApplication;
    @Inject
    private ObjectFactory objectFactory;

    public void initialize() throws InitializationException {
        this.setObjectFactory(this.objectFactory);
    }

    public Restlet createInboundRoot() {
        this.add(this.jaxrsApplication);
        XWikiSetupCleanupFilter setupCleanupFilter = new XWikiSetupCleanupFilter();
        XWikiAuthentication xwikiAuthentication = new XWikiAuthentication(this.getContext());
        ComponentManager componentManager = (ComponentManager)this.getContext().getAttributes().get("xwikiComponentManager");
        xwikiAuthentication.setVerifier((Verifier)new XWikiSecretVerifier(this.getContext(), componentManager));
        Router router = new Router();
        router.attach("/browser_authentication", BrowserAuthenticationResource.class);
        router.setDefaultMatchingMode(1);
        Restlet jaxRsRoot = super.createInboundRoot();
        this.getTunnelService().setEnabled(true);
        this.getMetadataService().addCommonExtensions();
        this.getTunnelService().setQueryTunnel(true);
        router.attach(jaxRsRoot);
        setupCleanupFilter.setNext((Restlet)xwikiAuthentication);
        xwikiAuthentication.setNext((Restlet)router);
        return setupCleanupFilter;
    }
}

