/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.io.InputStream;
import java.util.logging.LogManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.ext.servlet.ServerServlet;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.internal.JaxRsServletProvider;

public class XWikiRestletServlet
extends ServerServlet {
    private static final String JAVA_LOGGING_PROPERTY_FILE = "java-logging.properties";
    private static final long serialVersionUID = 9148448182654390153L;

    protected Application createApplication(Context context) {
        JaxRsApplication application;
        Context applicationContext = context.createChildContext();
        ComponentManager componentManager = this.getComponentManager();
        applicationContext.getAttributes().put("xwikiComponentManager", componentManager);
        try {
            application = (JaxRsApplication)componentManager.getInstance(JaxRsApplication.class);
        }
        catch (ComponentLookupException e) {
            this.log("Failed to lookup default JAX-RS Application", e);
            return null;
        }
        application.setContext(applicationContext);
        try {
            JaxRsServletProvider applicationProvider = (JaxRsServletProvider)componentManager.getInstance(JaxRsServletProvider.class);
            applicationProvider.setApplication((Servlet)this);
        }
        catch (ComponentLookupException e) {
            this.log("Failed to lookup JaxRsApplicationProvider. Dyncamically added/removed resources won'tbe supported", e);
        }
        return application;
    }

    public void destroy() {
        super.destroy();
        try {
            FieldUtils.writeField((Object)((Object)this), (String)"application", null, (boolean)true);
            FieldUtils.writeField((Object)((Object)this), (String)"component", null, (boolean)true);
            FieldUtils.writeField((Object)((Object)this), (String)"helper", null, (boolean)true);
            this.getServletContext().removeAttribute("org.restlet.ext.servlet.ServerServlet.server.RestletServlet");
            this.getServletContext().removeAttribute("org.restlet.ext.servlet.ServerServlet.application.RestletServlet");
            this.getServletContext().removeAttribute("org.restlet.ext.servlet.ServerServlet.component.RestletServlet");
        }
        catch (IllegalAccessException e) {
            this.log("Failed to destroy Restlet servlet", e);
        }
    }

    public void init() throws ServletException {
        block6: {
            super.init();
            try {
                InputStream is = this.getServletContext().getResourceAsStream(String.format("/WEB-INF/%s", JAVA_LOGGING_PROPERTY_FILE));
                if (is == null) {
                    is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(JAVA_LOGGING_PROPERTY_FILE);
                }
                if (is == null) break block6;
                try {
                    LogManager.getLogManager().readConfiguration(is);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            catch (Exception e) {
                this.log("Unable to initialize Java logging framework. Using defaults", e);
            }
        }
    }

    private ComponentManager getComponentManager() {
        ComponentManager result = (ComponentManager)this.getServletContext().getAttribute("org.xwiki.component.manager.ComponentManager");
        try {
            result = (ComponentManager)result.getInstance(ComponentManager.class, "context");
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return result;
    }
}

