/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.objects;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Enumeration;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Property;

@Component
@Named(value="org.xwiki.rest.internal.representations.objects.FormUrlEncodedPropertyReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedPropertyReader
implements MessageBodyReader<Property>,
XWikiRestComponent {
    private static final String PROPERTY_PREFIX = "property#";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return Property.class.isAssignableFrom(type);
    }

    public Property readFrom(Class<Property> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectFactory objectFactory = new ObjectFactory();
        Property property = objectFactory.createProperty();
        InputRepresentation representation = new InputRepresentation(entityStream, MediaType.APPLICATION_WWW_FORM);
        Form form = new Form((Representation)representation);
        if (form.getNames().isEmpty()) {
            HttpServletRequest httpServletRequest = ServletUtils.getRequest((Request)Request.getCurrent());
            Enumeration names = httpServletRequest.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(PROPERTY_PREFIX)) continue;
                property.setName(name.replace(PROPERTY_PREFIX, ""));
                property.setValue(httpServletRequest.getParameter(name));
                break;
            }
        } else {
            for (String name : form.getNames()) {
                if (!name.startsWith(PROPERTY_PREFIX)) continue;
                property.setName(name.replace(PROPERTY_PREFIX, ""));
                property.setValue(form.getFirstValue(name));
                break;
            }
        }
        return property;
    }
}

