/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.pages;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.Page;

@Component
@Named(value="org.xwiki.rest.internal.representations.pages.FormUrlEncodedPageReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedPageReader
implements MessageBodyReader<Page>,
XWikiRestComponent {
    private static final String TITLE_FIELD_NAME = "title";
    private static final String PARENT_FIELD_NAME = "parent";
    private static final String HIDDEN_FIELD_NAME = "hidden";
    private static final String CONTENT_FIELD_NAME = "content";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return Page.class.isAssignableFrom(type);
    }

    public Page readFrom(Class<Page> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectFactory objectFactory = new ObjectFactory();
        Page page = objectFactory.createPage();
        InputRepresentation representation = new InputRepresentation(entityStream, MediaType.APPLICATION_WWW_FORM);
        Form form = new Form((Representation)representation);
        if (form.getNames().isEmpty()) {
            HttpServletRequest httpServletRequest = ServletUtils.getRequest((Request)Request.getCurrent());
            page.setTitle(httpServletRequest.getParameter(TITLE_FIELD_NAME));
            page.setParent(httpServletRequest.getParameter(PARENT_FIELD_NAME));
            page.setHidden(Boolean.valueOf(httpServletRequest.getParameter(HIDDEN_FIELD_NAME)).booleanValue());
            page.setContent(httpServletRequest.getParameter(CONTENT_FIELD_NAME));
        } else {
            page.setTitle(form.getFirstValue(TITLE_FIELD_NAME));
            page.setParent(form.getFirstValue(PARENT_FIELD_NAME));
            page.setHidden(Boolean.valueOf(form.getFirstValue(HIDDEN_FIELD_NAME)).booleanValue());
            page.setContent(form.getFirstValue(CONTENT_FIELD_NAME));
        }
        return page;
    }
}

