/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.GroupsClass;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryBuilder;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rest.internal.resources.classes.AbstractUsersAndGroupsClassPropertyValuesProvider;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserManager;

@Component
@Named(value="Groups")
@Singleton
public class GroupsClassPropertyValuesProvider
extends AbstractUsersAndGroupsClassPropertyValuesProvider<GroupsClass> {
    private static final String DEFAULT_ICON_NAME = "group";
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private QueryBuilder<GroupsClass> allowedValuesQueryBuilder;

    @Override
    protected Class<GroupsClass> getPropertyType() {
        return GroupsClass.class;
    }

    @Override
    protected QueryBuilder<GroupsClass> getAllowedValuesQueryBuilder() {
        return this.allowedValuesQueryBuilder;
    }

    @Override
    protected PropertyValues getAllowedValues(GroupsClass propertyDefinition, int limit, String filter) throws Exception {
        String wikiId = propertyDefinition.getOwnerDocument().getDocumentReference().getWikiReference().getName();
        if (!Objects.equals(wikiId, this.wikiDescriptorManager.getMainWikiId()) && this.wikiUserManager.getUserScope(wikiId) != UserScope.LOCAL_ONLY) {
            return this.getLocalAndGlobalAllowedValues(propertyDefinition, limit, filter);
        }
        return this.getLocalAllowedValues(propertyDefinition, limit, filter);
    }

    @Override
    protected Map<String, Object> getIcon(DocumentReference groupReference) {
        Map<String, Object> icon = new HashMap<String, Object>();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            XWikiDocument groupProfileDocument = xcontext.getWiki().getDocument(groupReference, xcontext);
            XWikiAttachment avatarAttachment = this.getFirstImageAttachment(groupProfileDocument, xcontext);
            if (avatarAttachment != null) {
                icon.put("url", xcontext.getWiki().getURL((EntityReference)avatarAttachment.getReference(), "download", "width=30&height=30&keepAspectRatio=true", null, xcontext));
                icon.put("iconSetType", IconType.IMAGE.name());
            }
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to read the avatar of group [{}]. Root cause is [{}]. Using the default avatar instead.", (Object)groupReference.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        if (!icon.containsKey("url")) {
            try {
                icon = this.iconManager.getMetaData(DEFAULT_ICON_NAME);
            }
            catch (IconException e) {
                this.logger.warn("Error getting the icon [{}]. Root cause is [{}].", (Object)DEFAULT_ICON_NAME, (Object)ExceptionUtils.getRootCause((Throwable)e));
            }
        }
        return icon;
    }

    private XWikiAttachment getFirstImageAttachment(XWikiDocument document, XWikiContext xcontext) {
        for (XWikiAttachment attachment : document.getAttachmentList()) {
            if (!attachment.isImage(xcontext)) continue;
            return attachment;
        }
        return null;
    }

    @Override
    protected String getLabel(DocumentReference groupReference, Object currentLabel) {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            return xcontext.getWiki().getDocument(groupReference, xcontext).getRenderedTitle(Syntax.PLAIN_1_0, xcontext);
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to get the title of group [{}]. Root cause is [{}].", this.entityReferenceSerializer.serialize((EntityReference)groupReference, new Object[0]), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return super.getLabel(groupReference, currentLabel);
        }
    }
}

