/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.net.URI;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.objects.BaseObjectsResource;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.ObjectsResourceImpl")
public class ObjectsResourceImpl
extends BaseObjectsResource
implements ObjectsResource {
    public Objects getObjects(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Objects objects = this.objectFactory.createObjects();
            List<BaseObject> objectList = this.getBaseObjects(doc);
            RangeIterable<BaseObject> ri = new RangeIterable<BaseObject>(objectList, start, number);
            for (BaseObject object : ri) {
                if (object == null) continue;
                objects.getObjectSummaries().add(DomainObjectFactory.createObjectSummary(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, object, false, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            return objects;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response addObject(String wikiName, String spaceName, String pageName, Boolean minorRevision, Object object) throws XWikiRestException {
        if (object.getClassName() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            List<String> spaces = this.parseSpaceSegments(spaceName);
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaces, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getDocumentReference(), Utils.getXWikiContext(this.componentManager));
            BaseObject xwikiObject = xwikiDocument.newObject(object.getClassName(), Utils.getXWikiContext(this.componentManager));
            if (xwikiObject == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            BaseClass xwikiClass = Utils.getXWiki(this.componentManager).getClass(xwikiObject.getClassName(), Utils.getXWikiContext(this.componentManager));
            String[] stringArray = xwikiClass.getPropertyNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String propertyNameObject;
                String propertyName = propertyNameObject = stringArray[i];
                xwikiObject.set(propertyName, (java.lang.Object)"", Utils.getXWikiContext(this.componentManager));
            }
            for (Property property : object.getProperties()) {
                xwikiObject.set(property.getName(), (java.lang.Object)property.getValue(), Utils.getXWikiContext(this.componentManager));
            }
            doc.save("", Boolean.TRUE.equals(minorRevision));
            return Response.created((URI)Utils.createURI(this.uriInfo.getBaseUri(), ObjectResource.class, wikiName, spaces, pageName, object.getClassName(), xwikiObject.getNumber())).entity((java.lang.Object)DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, xwikiObject, false, Utils.getXWikiApi(this.componentManager), false)).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

