/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources;

import com.xpn.xwiki.XWikiException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.query.QueryException;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.spaces.SpaceResource;

public class BaseSearchResult
extends XWikiResource {
    protected static final String SEARCH_TEMPLATE_INFO = "q={keywords}(&scope={content|name|title|spaces|objects})*";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> search(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number) throws IllegalArgumentException, UriBuilderException, QueryException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            result.addAll(this.searchPages(searchScopes, keywords, wikiName, space, hasProgrammingRights, number));
            if (searchScopes.contains((Object)SearchScope.SPACES)) {
                result.addAll(this.searchSpaces(keywords, wikiName, hasProgrammingRights, number));
            }
            if (searchScopes.contains((Object)SearchScope.OBJECTS)) {
                result.addAll(this.searchObjects(keywords, wikiName, space, hasProgrammingRights, number));
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchPages(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc where doc.space = :space and ( ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc where ( ", new Object[0]);
            }
            int acceptedScopes = 0;
            for (int i = 0; i < searchScopes.size(); ++i) {
                SearchScope scope = searchScopes.get(i);
                switch (scope) {
                    case CONTENT: {
                        f.format("upper(doc.content) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case NAME: {
                        f.format("upper(doc.fullName) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case TITLE: {
                        f.format("upper(doc.title) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                    }
                }
                if (i == searchScopes.size() - 1) continue;
                f.format(" or ", new Object[0]);
            }
            if (acceptedScopes == 0) {
                ArrayList<SearchResult> i = result;
                return i;
            }
            if (hasProgrammingRights) {
                f.format(") order by doc.fullName asc", new Object[0]);
            } else {
                f.format(") and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by doc.fullName asc", new Object[0]);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String language = (String)fields[3];
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                if (!Utils.getXWikiApi(this.componentManager).hasAccessLevel("view", pageId)) continue;
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("page");
                searchResult.setId(pageId);
                searchResult.setPageFullName(Utils.getPageFullName(wikiName, spaceName, pageName));
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                String pageUri = null;
                try {
                    if (StringUtils.isBlank((CharSequence)language)) {
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8")}).toString();
                    } else {
                        searchResult.setLanguage(language);
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageTranslationResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8"), language}).toString();
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchSpaces(String keywords, String wikiName, boolean hasProgrammingRights, int number) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            f.format("select distinct doc.space from XWikiDocument as doc where upper(doc.space) like :keywords ", new Object[0]);
            if (hasProgrammingRights) {
                f.format(" order by doc.space asc", new Object[0]);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' order by doc.space asc", new Object[0]);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                String spaceName = (String)object;
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("space");
                searchResult.setId(String.format("%s:%s", wikiName, spaceName));
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                Link spaceLink = new Link();
                spaceLink.setRel("http://www.xwiki.org/rel/space");
                String spaceUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(SpaceResource.class).build(new Object[]{wikiName, spaceName}).toString();
                spaceLink.setHref(spaceUri);
                searchResult.getLinks().add(spaceLink);
                String webHomePageId = Utils.getPageId(wikiName, spaceName, "WebHome");
                if (Utils.getXWikiApi(this.componentManager).exists(webHomePageId) && Utils.getXWikiApi(this.componentManager).hasAccessLevel("view", webHomePageId)) {
                    String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, "WebHome"}).toString();
                    Link pageLink = new Link();
                    pageLink.setHref(pageUri);
                    pageLink.setRel("http://www.xwiki.org/rel/home");
                    searchResult.getLinks().add(pageLink);
                }
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchObjects(String keywords, String wikiName, String space, boolean hasProgrammingRights, int number) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where doc.space = :space and obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            }
            if (hasProgrammingRights) {
                f.format(" order by doc.fullName asc", new Object[0]);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by doc.fullName asc", new Object[0]);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String className = (String)fields[3];
                int objectNumber = (Integer)fields[4];
                String id = Utils.getObjectId(wikiName, spaceName, pageName, className, objectNumber);
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                if (!Utils.getXWikiApi(this.componentManager).hasAccessLevel("view", pageId)) continue;
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("object");
                searchResult.setId(id);
                searchResult.setPageFullName(Utils.getPageFullName(wikiName, spaceName, pageName));
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setClassName(className);
                searchResult.setObjectNumber(Integer.valueOf(objectNumber));
                String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                String objectUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new Object[]{wikiName, spaceName, pageName, className, objectNumber}).toString();
                Link objectLink = new Link();
                objectLink.setHref(objectUri);
                objectLink.setRel("http://www.xwiki.org/rel/object");
                searchResult.getLinks().add(objectLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    protected List<SearchScope> parseSearchScopeStrings(List<String> searchScopeStrings) {
        ArrayList<SearchScope> searchScopes = new ArrayList<SearchScope>();
        for (String searchScopeString : searchScopeStrings) {
            if (searchScopeString == null || searchScopes.contains(searchScopeString)) continue;
            try {
                SearchScope searchScope = SearchScope.valueOf(searchScopeString.toUpperCase());
                searchScopes.add(searchScope);
            }
            catch (IllegalArgumentException e) {}
        }
        if (searchScopes.isEmpty()) {
            searchScopes.add(SearchScope.CONTENT);
        }
        return searchScopes;
    }

    protected static enum SearchScope {
        SPACES,
        NAME,
        CONTENT,
        TITLE,
        OBJECTS;

    }
}

