/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources;

import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;

@Component(value="org.xwiki.rest.resources.ModificationsResource")
@Path(value="/wikis/{wikiName}/modifications")
public class ModificationsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public History getModifications(@PathParam(value="wikiName") String wikiName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="25") Integer number, @QueryParam(value="order") @DefaultValue(value="desc") String order, @QueryParam(value="date") @DefaultValue(value="0") Long ts) throws QueryException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        History history = new History();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            String query = String.format("select doc.space, doc.name, doc.language, rcs.id, rcs.date, rcs.author from XWikiRCSNodeInfo as rcs, XWikiDocument as doc where rcs.id.docId=doc.id and rcs.date > :date order by rcs.date %s, rcs.id.version1 %s, rcs.id.version2 %s", order, order, order);
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("date", (Object)new Date(ts)).setLimit(number.intValue()).setOffset(start.intValue()).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[0];
                String pageName = (String)fields[1];
                String language = (String)fields[2];
                if (language.equals("")) {
                    language = null;
                }
                XWikiRCSNodeId nodeId = (XWikiRCSNodeId)fields[3];
                Timestamp timestamp = (Timestamp)fields[4];
                Date modified = new Date(timestamp.getTime());
                String modifier = (String)fields[5];
                HistorySummary historySummary = DomainObjectFactory.createHistorySummary(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaceName, pageName, language, nodeId.getVersion(), modifier, modified);
                history.getHistorySummaries().add(historySummary);
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return history;
    }
}

