/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.List;
import java.util.regex.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Pages;

@Component(value="org.xwiki.rest.resources.pages.PagesResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName}/pages")
public class PagesResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Pages getPages(@PathParam(value="wikiName") String wikiName, @PathParam(value="spaceName") String spaceName, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number, @QueryParam(value="parentId") String parentFilterExpression) throws XWikiException, QueryException, ComponentLookupException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        Pages pages = this.objectFactory.createPages();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            List pageNames = this.queryManager.getNamedQuery("getSpaceDocsName").addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "hidden")).bindValue("space", (Object)spaceName).setOffset(start.intValue()).setLimit(number.intValue()).execute();
            Pattern parentFilter = null;
            if (parentFilterExpression != null) {
                parentFilter = parentFilterExpression.equals("null") ? Pattern.compile("") : Pattern.compile(parentFilterExpression);
            }
            for (String pageName : pageNames) {
                String pageFullName = Utils.getPageId(wikiName, spaceName, pageName);
                if (!Utils.getXWikiApi(this.componentManager).exists(pageFullName)) {
                    this.logger.warning(String.format("[Page '%s' appears to be in space '%s' but no information is available.]", pageName, spaceName));
                    continue;
                }
                Document doc = Utils.getXWikiApi(this.componentManager).getDocument(pageFullName);
                if (doc == null) continue;
                boolean add = true;
                Document parent = Utils.getParentDocument(doc, Utils.getXWikiApi(this.componentManager));
                if (parentFilter != null) {
                    String parentId = "";
                    if (parent != null && !parent.isNew()) {
                        parentId = parent.getPrefixedFullName();
                    }
                    add = parentFilter.matcher(parentId).matches();
                }
                if (!add) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, Utils.getXWikiApi(this.componentManager)));
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return pages;
    }
}

