/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URL;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.wikis.WikiPagesResource;

@Component(value="org.xwiki.rest.internal.resources.wikis.WikiPagesResourceImpl")
public class WikiPagesResourceImpl
extends XWikiResource
implements WikiPagesResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pages getPages(String wikiName, Integer start, String name, String space, String author, Integer number) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        Pages pages = this.objectFactory.createPages();
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            if (!name.equals("")) {
                filters.put("name", name);
            }
            if (!space.equals("")) {
                filters.put("space", space);
            }
            if (!author.equals("")) {
                filters.put("author", author);
            }
            Formatter f = new Formatter();
            f.format("select doc from XWikiDocument as doc", new Object[0]);
            if (filters.keySet().size() > 0) {
                f.format(" where (", new Object[0]);
                int i = 0;
                for (String param : filters.keySet()) {
                    if (param.equals("name")) {
                        f.format(" upper(doc.fullName) like :name ", new Object[0]);
                    }
                    if (param.equals("space")) {
                        f.format(" upper(doc.space) like :space ", new Object[0]);
                    }
                    if (param.equals("author")) {
                        f.format(" upper(doc.contentAuthor) like :author ", new Object[0]);
                    }
                    if (++i >= filters.keySet().size()) continue;
                    f.format(" and ", new Object[0]);
                }
                f.format(")", new Object[0]);
            }
            String queryString = f.toString();
            List queryResult = null;
            try {
                Query query = this.queryManager.createQuery(queryString, "xwql").setLimit(number.intValue()).setOffset(start.intValue());
                for (String param : filters.keySet()) {
                    query.bindValue(param, (Object)String.format("%%%s%%", ((String)filters.get(param)).toUpperCase()));
                }
                queryResult = null;
                queryResult = query.execute();
            }
            catch (QueryException e) {
                throw new XWikiRestException((Throwable)e);
            }
            for (Object object : queryResult) {
                XWikiDocument xwikiDocument = (XWikiDocument)object;
                xwikiDocument.setDatabase(wikiName);
                Document doc = new Document(xwikiDocument, Utils.getXWikiContext(this.componentManager));
                PageSummary pageSummary = this.objectFactory.createPageSummary();
                pageSummary.setId(doc.getPrefixedFullName());
                pageSummary.setFullName(doc.getFullName());
                pageSummary.setWiki(wikiName);
                pageSummary.setSpace(doc.getSpace());
                pageSummary.setName(doc.getName());
                pageSummary.setTitle(doc.getTitle());
                pageSummary.setParent(doc.getParent());
                URL absoluteUrl = Utils.getXWikiContext(this.componentManager).getURLFactory().createExternalURL(doc.getSpace(), doc.getName(), "view", null, null, Utils.getXWikiContext(this.componentManager));
                pageSummary.setXwikiAbsoluteUrl(absoluteUrl.toString());
                pageSummary.setXwikiRelativeUrl(Utils.getXWikiContext(this.componentManager).getURLFactory().getURL(absoluteUrl, Utils.getXWikiContext(this.componentManager)));
                String baseUri = this.uriInfo.getBaseUri().toString();
                String pageUri = UriBuilder.fromUri((String)baseUri).path(PageResource.class).build(new Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
                Link pageLink = this.objectFactory.createLink();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                pageSummary.getLinks().add(pageLink);
                pages.getPageSummaries().add(pageSummary);
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return pages;
    }
}

