/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.SearchResults;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.spaces.SpaceResource;

public class BaseSearchResult
extends XWikiResource {
    protected static final String SEARCH_TEMPLATE_INFO = "q={keywords}(&scope={content|name|title|spaces|objects})*(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&prettyNames={false|true})";
    protected static final String MULTIWIKI_QUERY_TEMPLATE_INFO = "q={lucenequery}(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&distinct=1)(&prettyNames={false|true})(&wikis={wikis})(&className={classname})";
    protected static final String QUERY_TEMPLATE_INFO = "q={query}(&type={xwql,hql,lucene})(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&distinct=1)(&prettyNames={false|true})(&wikis={wikis})(&className={classname})";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> search(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, boolean distinct, String orderField, String order, Boolean withPrettyNames) throws IllegalArgumentException, UriBuilderException, QueryException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            result.addAll(this.searchPages(searchScopes, keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames));
            if (searchScopes.contains((Object)SearchScope.SPACES)) {
                result.addAll(this.searchSpaces(keywords, wikiName, hasProgrammingRights, number, start));
            }
            if (searchScopes.contains((Object)SearchScope.OBJECTS)) {
                result.addAll(this.searchObjects(keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames));
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchPages(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            String addColumn = "";
            if (!StringUtils.isBlank((CharSequence)orderField)) {
                String string = addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            }
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc where doc.space = :space and ( ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc where ( ", new Object[0]);
            }
            int acceptedScopes = 0;
            for (int i = 0; i < searchScopes.size(); ++i) {
                SearchScope scope = searchScopes.get(i);
                switch (scope) {
                    case CONTENT: {
                        f.format("upper(doc.content) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case NAME: {
                        f.format("upper(doc.fullName) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case TITLE: {
                        f.format("upper(doc.title) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                    }
                }
                if (i == searchScopes.size() - 1) continue;
                f.format(" or ", new Object[0]);
            }
            if (acceptedScopes == 0) {
                ArrayList<SearchResult> i = result;
                return i;
            }
            String orderClause = null;
            orderClause = StringUtils.isBlank((CharSequence)orderField) ? "doc.fullName asc" : ("asc".equals(order) || "desc".equals(order) ? String.format("doc.%s %s", orderField, order) : String.format("doc.%s asc", orderField));
            if (hasProgrammingRights) {
                f.format(") order by %s", orderClause);
            } else {
                f.format(") and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by %s", orderClause);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).setOffset(start).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).setOffset(start).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String language = (String)fields[3];
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("page");
                searchResult.setId(pageId);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthor(), this.componentManager));
                }
                String pageUri = null;
                try {
                    if (StringUtils.isBlank((CharSequence)language)) {
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8")}).toString();
                    } else {
                        searchResult.setLanguage(language);
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageTranslationResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8"), language}).toString();
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchSpaces(String keywords, String wikiName, boolean hasProgrammingRights, int number, int start) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            f.format("select distinct doc.space from XWikiDocument as doc where upper(doc.space) like :keywords ", new Object[0]);
            if (hasProgrammingRights) {
                f.format(" order by doc.space asc", new Object[0]);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' order by doc.space asc", new Object[0]);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).setOffset(start).execute();
            for (Object object : queryResult) {
                String spaceName = (String)object;
                Document spaceDoc = xwikiApi.getDocument(String.format("%s.WebHome", spaceName));
                if (!xwikiApi.hasAccessLevel("view", spaceDoc.getPrefixedFullName())) continue;
                String title = spaceDoc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("space");
                searchResult.setId(String.format("%s:%s", wikiName, spaceName));
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setTitle(title);
                Link spaceLink = new Link();
                spaceLink.setRel("http://www.xwiki.org/rel/space");
                String spaceUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(SpaceResource.class).build(new Object[]{wikiName, spaceName}).toString();
                spaceLink.setHref(spaceUri);
                searchResult.getLinks().add(spaceLink);
                String webHomePageId = Utils.getPageId(wikiName, spaceName, "WebHome");
                if (xwikiApi.exists(webHomePageId) && xwikiApi.hasAccessLevel("view", webHomePageId)) {
                    String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, "WebHome"}).toString();
                    Link pageLink = new Link();
                    pageLink.setHref(pageUri);
                    pageLink.setRel("http://www.xwiki.org/rel/home");
                    searchResult.getLinks().add(pageLink);
                }
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchObjects(String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            String addColumn;
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            String string = addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where doc.space = :space and obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            }
            String orderClause = null;
            orderClause = StringUtils.isBlank((CharSequence)orderField) ? "doc.fullName asc" : ("asc".equals(order) || "desc".equals(order) ? String.format("doc.%s %s", orderField, order) : String.format("doc.%s asc", orderField));
            if (hasProgrammingRights) {
                f.format(" order by %s", orderClause);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by %s", orderClause);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String className = (String)fields[3];
                int objectNumber = (Integer)fields[4];
                String id = Utils.getObjectId(wikiName, spaceName, pageName, className, objectNumber);
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId) || xwikiContext.getUserReference() == null) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("object");
                searchResult.setId(id);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setClassName(className);
                searchResult.setObjectNumber(Integer.valueOf(objectNumber));
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthor(), this.componentManager));
                }
                String pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).build(new Object[]{wikiName, spaceName, pageName}).toString();
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                String objectUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new Object[]{wikiName, spaceName, pageName, className, objectNumber}).toString();
                Link objectLink = new Link();
                objectLink.setHref(objectUri);
                objectLink.setRel("http://www.xwiki.org/rel/object");
                searchResult.getLinks().add(objectLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchQuery(String query, String queryTypeString, String wikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            QueryType queryType = this.parseQueryType(queryTypeString);
            if (queryType != null) {
                switch (queryType) {
                    case LUCENE: {
                        result.addAll(this.searchLucene(query, wikiName, wikis, hasProgrammingRights, orderField, order, number, start, withPrettyNames));
                        break;
                    }
                    case XWQL: {
                        result.addAll(this.searchDatabaseQuery(query, "xwql", wikiName, hasProgrammingRights, distinct, number, start, withPrettyNames, className));
                        break;
                    }
                    case HQL: {
                        result.addAll(this.searchDatabaseQuery(query, "hql", wikiName, hasProgrammingRights, distinct, number, start, withPrettyNames, className));
                    }
                }
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchDatabaseQuery(String query, String queryLanguage, String wikiName, boolean hasProgrammingRights, boolean distinct, int number, int start, Boolean withPrettyNames, String className) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (query == null || query.trim().startsWith("select")) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            if (distinct) {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc %s", query);
            } else {
                f.format("select doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc %s", query);
            }
            String squery = f.toString();
            if (!hasProgrammingRights) {
                squery.replace("where ", "where doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' and ");
            }
            List queryResult = null;
            queryResult = this.queryManager.createQuery(squery, queryLanguage).setLimit(number).setOffset(start).execute();
            for (Object object : queryResult) {
                BaseObject baseObject;
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String language = (String)fields[3];
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("page");
                searchResult.setId(pageId);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthor(), this.componentManager));
                }
                if (className != null && !className.equals("") && xwikiContext.getUserReference() != null && (baseObject = Utils.getBaseObject(doc, className, 0, this.componentManager)) != null) {
                    searchResult.setObject(DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), xwikiContext, doc, baseObject, false, xwikiApi, false));
                }
                String pageUri = null;
                try {
                    if (StringUtils.isBlank((CharSequence)language)) {
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8")}).toString();
                    } else {
                        searchResult.setLanguage(language);
                        pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageTranslationResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8"), language}).toString();
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchLucene(String query, String defaultWikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, int number, int start, Boolean withPrettyNames) throws IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (query == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            if (defaultWikiName == null && wikis == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            if (!hasProgrammingRights) {
                query = query + " AND NOT space:XWiki AND NOT space:Admin AND NOT space:Panels AND NOT name:WebPreferences";
            }
            try {
                XWikiContext context = Utils.getXWikiContext(this.componentManager);
                LucenePlugin lucene = (LucenePlugin)Utils.getXWiki(this.componentManager).getPlugin("lucene", context);
                String orderParameter = "";
                if (!StringUtils.isBlank((CharSequence)orderField)) {
                    orderParameter = "desc".equals(order) ? String.format("-%s", orderField) : orderField;
                }
                SearchResults luceneSearchResults = lucene.getSearchResults(query, orderParameter, wikis == null ? defaultWikiName : wikis, "", context);
                List luceneResults = luceneSearchResults.getResults(start + 1, number == -1 ? 20 : number);
                for (com.xpn.xwiki.plugin.lucene.SearchResult luceneSearchResult : luceneResults) {
                    String language;
                    String wikiName = luceneSearchResult.getWiki();
                    String spaceName = luceneSearchResult.getSpace();
                    String pageName = luceneSearchResult.getName();
                    String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                    String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                    if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
                    Document doc = xwikiApi.getDocument(pageId);
                    String title = doc.getDisplayTitle();
                    SearchResult searchResult = this.objectFactory.createSearchResult();
                    searchResult.setPageFullName(pageFullName);
                    searchResult.setTitle(title);
                    searchResult.setWiki(wikiName);
                    searchResult.setSpace(spaceName);
                    searchResult.setPageName(pageName);
                    searchResult.setVersion(doc.getVersion());
                    if (luceneSearchResult.getType().equals("wikipage")) {
                        searchResult.setType("page");
                        searchResult.setId(Utils.getPageId(wikiName, spaceName, pageName));
                    } else {
                        searchResult.setType("file");
                        searchResult.setId(String.format("%s@%s", Utils.getPageId(wikiName, pageFullName), luceneSearchResult.getFilename()));
                        searchResult.setFilename(luceneSearchResult.getFilename());
                        String attachmentUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(AttachmentResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8"), URLEncoder.encode(luceneSearchResult.getFilename(), "UTF-8")}).toString();
                        Link attachmentLink = new Link();
                        attachmentLink.setHref(attachmentUri);
                        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
                        searchResult.getLinks().add(attachmentLink);
                    }
                    searchResult.setScore(Float.valueOf(luceneSearchResult.getScore()));
                    searchResult.setAuthor(luceneSearchResult.getAuthor());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(doc.getDate());
                    searchResult.setModified(calendar);
                    if (withPrettyNames.booleanValue()) {
                        searchResult.setAuthorName(Utils.getAuthorName(luceneSearchResult.getAuthor(), this.componentManager));
                    }
                    if ((language = luceneSearchResult.getLanguage()).equals("default")) {
                        language = "";
                    }
                    String pageUri = null;
                    try {
                        if (StringUtils.isBlank((CharSequence)language)) {
                            pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8")}).toString();
                        } else {
                            searchResult.setLanguage(language);
                            pageUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(PageTranslationResource.class).buildFromEncoded(new Object[]{URLEncoder.encode(wikiName, "UTF-8"), URLEncoder.encode(spaceName, "UTF-8"), URLEncoder.encode(pageName, "UTF-8"), language}).toString();
                        }
                    }
                    catch (UnsupportedEncodingException ex) {
                        // empty catch block
                    }
                    Link pageLink = new Link();
                    pageLink.setHref(pageUri);
                    pageLink.setRel("http://www.xwiki.org/rel/page");
                    searchResult.getLinks().add(pageLink);
                    result.add(searchResult);
                }
            }
            catch (Exception e) {
                throw new XWikiException(0, 0, "Error performing lucene search", (Throwable)e);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    protected List<SearchScope> parseSearchScopeStrings(List<String> searchScopeStrings) {
        ArrayList<SearchScope> searchScopes = new ArrayList<SearchScope>();
        for (String searchScopeString : searchScopeStrings) {
            if (searchScopeString == null || searchScopes.contains(searchScopeString)) continue;
            try {
                SearchScope searchScope = SearchScope.valueOf(searchScopeString.toUpperCase());
                searchScopes.add(searchScope);
            }
            catch (IllegalArgumentException e) {}
        }
        if (searchScopes.isEmpty()) {
            searchScopes.add(SearchScope.CONTENT);
        }
        return searchScopes;
    }

    protected QueryType parseQueryType(String queryTypeString) {
        try {
            if (queryTypeString != null) {
                return QueryType.valueOf(queryTypeString.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected static enum QueryType {
        XWQL,
        HQL,
        LUCENE;

    }

    protected static enum SearchScope {
        SPACES,
        NAME,
        CONTENT,
        TITLE,
        OBJECTS;

    }
}

