/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Multipart;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseAttachmentsResource;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;

@Component(value="org.xwiki.rest.internal.resources.attachments.AttachmentsResourceImpl")
public class AttachmentsResourceImpl
extends BaseAttachmentsResource
implements AttachmentsResource {
    private static String FORM_FILENAME_FIELD = "filename";

    public Attachments getAttachments(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            return this.getAttachmentsForDocument(doc, start, number, withPrettyNames);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response addAttachment(String wikiName, String spaceName, String pageName, Multipart multipart) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            String attachmentName = null;
            String actualFileName = null;
            String overriddenFileName = null;
            String contentType = null;
            InputStream inputStream = null;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                Enumeration e = bodyPart.getMatchingHeaders(new String[]{"Content-disposition"});
                while (e.hasMoreElements()) {
                    String[] fieldData;
                    Header h = (Header)e.nextElement();
                    if (!h.getValue().startsWith("form-data")) continue;
                    for (String s : fieldData = h.getValue().split(";")) {
                        String[] pair = s.split("=");
                        if (pair.length != 2) continue;
                        String key = pair[0].trim();
                        String value = pair[1].replace("\"", "").trim();
                        if ("name".equals(key)) {
                            if (!FORM_FILENAME_FIELD.equals(value)) continue;
                            overriddenFileName = bodyPart.getContent().toString();
                            continue;
                        }
                        if (!"filename".equals(key)) continue;
                        actualFileName = value;
                        contentType = bodyPart.getContentType();
                        inputStream = bodyPart.getInputStream();
                    }
                }
            }
            attachmentName = overriddenFileName != null ? overriddenFileName : actualFileName;
            if (attachmentName == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (true) {
                int read;
                if ((read = inputStream.read(buffer)) != 4096) {
                    if (read == -1) break;
                    baos.write(buffer, 0, read);
                    break;
                }
                baos.write(buffer);
            }
            baos.flush();
            BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAttachment(doc, attachmentName, baos.toByteArray());
            if (attachmentInfo.isAlreadyExisting()) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
            }
            return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(AttachmentResource.class).build(new Object[]{wikiName, spaceName, pageName, attachmentName})).entity((Object)attachmentInfo.getAttachment()).build();
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

