/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectPropertyResource;
import org.xwiki.rest.resources.objects.ObjectResource;

@Component(value="org.xwiki.rest.internal.resources.objects.ObjectPropertyResourceImpl")
public class ObjectPropertyResourceImpl
extends XWikiResource
implements ObjectPropertyResource {
    public Property getObjectProperty(String wikiName, String spaceName, String pageName, String className, Integer objectNumber, String propertyName, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(this.componentManager));
            BaseObject baseObject = xwikiDocument.getObject(className, objectNumber.intValue());
            if (baseObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Object object = DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, false, Utils.getXWikiApi(this.componentManager), withPrettyNames);
            for (Property property : object.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                String objectUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), object.getClassName(), object.getNumber()}).toString();
                Link objectLink = this.objectFactory.createLink();
                objectLink.setHref(objectUri);
                objectLink.setRel("http://www.xwiki.org/rel/object");
                property.getLinks().add(objectLink);
                return property;
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response updateObjectProperty(String wikiName, String spaceName, String pageName, String className, Integer objectNumber, String propertyName, Property property) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(this.componentManager));
            BaseObject baseObject = xwikiDocument.getObject(className, objectNumber.intValue());
            if (baseObject == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            baseObject.set(propertyName, (java.lang.Object)property.getValue(), Utils.getXWikiContext(this.componentManager));
            doc.save();
            baseObject = xwikiDocument.getObject(className, objectNumber.intValue());
            Object object = DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, baseObject, false, Utils.getXWikiApi(this.componentManager), false);
            for (Property p : object.getProperties()) {
                if (!p.getName().equals(propertyName)) continue;
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((java.lang.Object)p).build();
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

