/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.exceptions;

import com.xpn.xwiki.XWikiException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.XWikiRestException;

@Component(value="org.xwiki.rest.internal.exceptions.XWikiRestExceptionMapper")
@Provider
public class XWikiRestExceptionMapper
implements ExceptionMapper<XWikiRestException>,
XWikiRestComponent {
    public Response toResponse(XWikiRestException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof XWikiException) {
            XWikiException xwikiException = (XWikiException)cause;
            if (xwikiException.getCode() == 9001) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exception.getMessage()).type("text/plain").build();
            }
        } else if (cause instanceof QueryException) {
            QueryException queryException = (QueryException)cause;
            return Response.serverError().entity((Object)String.format("%s\n%s\n", exception.getMessage(), queryException.getCause().getMessage())).type("text/plain").build();
        }
        return Response.serverError().entity((Object)exception.getMessage()).type("text/plain").build();
    }
}

