/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rest.internal.representations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

import javax.ws.rs.ext.MessageBodyReader;

import org.xwiki.rest.XWikiRestComponent;

/**
 * @version $Id: 8a1381159a5ae0ff68d73f0856b94d639a2a0be6 $
 */
public abstract class TextPlainReader<T> implements MessageBodyReader<T>, XWikiRestComponent
{
    protected String getEntityAsString(InputStream entityStream) throws IOException
    {
        StringWriter writer = new StringWriter();
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.write(line);
        }

        return writer.toString();
    }
}
