/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Element;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.Property;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attribute;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Translations;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Xwiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.comments.CommentsVersionResource;
import org.xwiki.rest.resources.objects.AllObjectsForClassNameResource;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesResource;
import org.xwiki.rest.resources.objects.ObjectPropertyAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertyResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.pages.PageTranslationHistoryResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.pages.PageTranslationVersionResource;
import org.xwiki.rest.resources.pages.PageVersionResource;
import org.xwiki.rest.resources.pages.PagesResource;
import org.xwiki.rest.resources.spaces.SpaceResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;

public class DomainObjectFactory {
    public static Xwiki createXWikiRoot(ObjectFactory objectFactory, URI baseUri, String version) {
        Xwiki xwiki = objectFactory.createXwiki().withVersion(version);
        String wikisUri = DomainObjectFactory.uri(baseUri, WikisResource.class, new java.lang.Object[0]);
        Link wikisLink = objectFactory.createLink();
        wikisLink.setHref(wikisUri);
        wikisLink.setRel("http://www.xwiki.org/rel/wikis");
        xwiki.getLinks().add(wikisLink);
        String syntaxesUri = DomainObjectFactory.uri(baseUri, SyntaxesResource.class, new java.lang.Object[0]);
        Link syntaxesLink = objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        xwiki.getLinks().add(syntaxesLink);
        return xwiki;
    }

    public static Wiki createWiki(ObjectFactory objectFactory, URI baseUri, String wikiName) {
        Wiki wiki = objectFactory.createWiki().withId(wikiName).withName(wikiName);
        String spacesUri = DomainObjectFactory.uri(baseUri, SpacesResource.class, wikiName);
        Link spacesLink = objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = DomainObjectFactory.uri(baseUri, ClassesResource.class, wikiName);
        Link classesLink = objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = DomainObjectFactory.uri(baseUri, ModificationsResource.class, wikiName);
        Link modificationsLink = objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = DomainObjectFactory.uri(baseUri, WikiSearchResource.class, wikiName);
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        String queryUri = DomainObjectFactory.uri(baseUri, WikiSearchQueryResource.class, wikiName);
        Link queryLink = objectFactory.createLink();
        queryLink.setHref(queryUri);
        queryLink.setRel("http://www.xwiki.org/rel/query");
        wiki.getLinks().add(queryLink);
        return wiki;
    }

    public static Space createSpace(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, Document home) {
        Space space = objectFactory.createSpace();
        space.setId(Utils.getSpaceId(wikiName, spaceName));
        space.setWiki(wikiName);
        space.setName(spaceName);
        if (home != null) {
            space.setHome(home.getPrefixedFullName());
            space.setXwikiRelativeUrl(home.getURL("view"));
            space.setXwikiAbsoluteUrl(home.getExternalURL("view"));
        }
        String pagesUri = DomainObjectFactory.uri(baseUri, PagesResource.class, wikiName, spaceName);
        Link pagesLink = objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("http://www.xwiki.org/rel/pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = DomainObjectFactory.uri(baseUri, PageResource.class, wikiName, spaceName, home.getName());
            Link homeLink = objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("http://www.xwiki.org/rel/home");
            space.getLinks().add(homeLink);
        }
        String searchUri = DomainObjectFactory.uri(baseUri, SpaceSearchResource.class, wikiName, spaceName);
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        space.getLinks().add(searchLink);
        return space;
    }

    public static Translations createTranslations(ObjectFactory objectFactory, URI baseUri, Document doc) throws XWikiException {
        Translations translations = objectFactory.createTranslations();
        List languages = doc.getTranslationList();
        if (!languages.isEmpty() && !doc.getDefaultLanguage().equals("")) {
            translations.setDefault(doc.getDefaultLanguage());
            Translation translation = objectFactory.createTranslation();
            translation.setLanguage(doc.getDefaultLanguage());
            String pageTranslationUri = DomainObjectFactory.uri(baseUri, PageResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link pageTranslationLink = objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = DomainObjectFactory.uri(baseUri, PageHistoryResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link historyLink = objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        for (String language : languages) {
            Translation translation = objectFactory.createTranslation();
            translation.setLanguage(language);
            String pageTranslationUri = DomainObjectFactory.uri(baseUri, PageTranslationResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), language);
            Link pageTranslationLink = objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = DomainObjectFactory.uri(baseUri, PageTranslationHistoryResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), language);
            Link historyLink = objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        return translations;
    }

    private static void fillPageSummary(PageSummary pageSummary, ObjectFactory objectFactory, URI baseUri, Document doc, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        Object tagsObject;
        pageSummary.setWiki(doc.getWiki());
        pageSummary.setFullName(doc.getFullName());
        pageSummary.setId(doc.getPrefixedFullName());
        pageSummary.setSpace(doc.getSpace());
        pageSummary.setName(doc.getName());
        pageSummary.setTitle(doc.getDisplayTitle());
        pageSummary.setXwikiRelativeUrl(doc.getURL("view"));
        pageSummary.setXwikiAbsoluteUrl(doc.getExternalURL("view"));
        pageSummary.setTranslations(DomainObjectFactory.createTranslations(objectFactory, baseUri, doc));
        pageSummary.setSyntax(doc.getSyntaxId());
        pageSummary.setVersion(doc.getVersion());
        pageSummary.setAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            pageSummary.setAuthorName(xwikiApi.getUserName(doc.getAuthor(), false));
        }
        Document parent = Utils.getParentDocument(doc, xwikiApi);
        pageSummary.setParent(doc.getParent());
        if (parent != null && !parent.isNew()) {
            pageSummary.setParentId(parent.getPrefixedFullName());
        } else {
            pageSummary.setParentId("");
        }
        String spaceUri = DomainObjectFactory.uri(baseUri, SpaceResource.class, doc.getWiki(), doc.getSpace());
        Link spaceLink = objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("http://www.xwiki.org/rel/space");
        pageSummary.getLinks().add(spaceLink);
        if (parent != null) {
            String parentUri = DomainObjectFactory.uri(baseUri, PageResource.class, parent.getWiki(), parent.getSpace(), parent.getName());
            Link parentLink = objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("http://www.xwiki.org/rel/parent");
            pageSummary.getLinks().add(parentLink);
        }
        String historyUri = DomainObjectFactory.uri(baseUri, PageHistoryResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
        Link historyLink = objectFactory.createLink();
        historyLink.setHref(historyUri);
        historyLink.setRel("http://www.xwiki.org/rel/history");
        pageSummary.getLinks().add(historyLink);
        if (!doc.getChildren().isEmpty()) {
            String pageChildrenUri = DomainObjectFactory.uri(baseUri, PageChildrenResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link pageChildrenLink = objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("http://www.xwiki.org/rel/children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!doc.getComments().isEmpty()) {
            String commentsUri = useVersion ? DomainObjectFactory.uri(baseUri, CommentsVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()) : DomainObjectFactory.uri(baseUri, CommentsResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link commentsLink = objectFactory.createLink();
            commentsLink.setHref(commentsUri);
            commentsLink.setRel("http://www.xwiki.org/rel/comments");
            pageSummary.getLinks().add(commentsLink);
        }
        if (!doc.getAttachmentList().isEmpty()) {
            String attachmentsUri = useVersion ? DomainObjectFactory.uri(baseUri, AttachmentsAtPageVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()) : DomainObjectFactory.uri(baseUri, AttachmentsResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link attachmentsLink = objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("http://www.xwiki.org/rel/attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
        if (!doc.getxWikiObjects().keySet().isEmpty()) {
            String objectsUri = useVersion ? DomainObjectFactory.uri(baseUri, ObjectsAtPageVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()) : DomainObjectFactory.uri(baseUri, ObjectsResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link objectsLink = objectFactory.createLink();
            objectsLink.setHref(objectsUri);
            objectsLink.setRel("http://www.xwiki.org/rel/objects");
            pageSummary.getLinks().add(objectsLink);
        }
        if ((tagsObject = doc.getObject("XWiki.TagClass", 0)) != null && tagsObject.getProperty("tags") != null) {
            String tagsUri = DomainObjectFactory.uri(baseUri, PageTagsResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
            Link tagsLink = objectFactory.createLink();
            tagsLink.setHref(tagsUri);
            tagsLink.setRel("http://www.xwiki.org/rel/tags");
            pageSummary.getLinks().add(tagsLink);
        }
        String syntaxesUri = DomainObjectFactory.uri(baseUri, SyntaxesResource.class, new java.lang.Object[0]);
        Link syntaxesLink = objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        pageSummary.getLinks().add(syntaxesLink);
    }

    public static PageSummary createPageSummary(ObjectFactory objectFactory, URI baseUri, Document doc, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        PageSummary pageSummary = objectFactory.createPageSummary();
        DomainObjectFactory.fillPageSummary(pageSummary, objectFactory, baseUri, doc, false, xwikiApi, withPrettyNames);
        String pageUri = DomainObjectFactory.uri(baseUri, PageResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public static Page createPage(ObjectFactory objectFactory, URI baseUri, URI self, Document doc, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        Class xwikiClass;
        Page page = objectFactory.createPage();
        DomainObjectFactory.fillPageSummary((PageSummary)page, objectFactory, baseUri, doc, useVersion, xwikiApi, withPrettyNames);
        page.setMajorVersion(doc.getRCSVersion().at(0));
        page.setMinorVersion(doc.getRCSVersion().at(1));
        page.setLanguage(doc.getLanguage());
        page.setCreator(doc.getCreator());
        if (withPrettyNames.booleanValue()) {
            page.setCreatorName(xwikiApi.getUserName(doc.getCreator(), false));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(doc.getCreationDate());
        page.setCreated(calendar);
        page.setModifier(doc.getContentAuthor());
        if (withPrettyNames.booleanValue()) {
            page.setModifierName(xwikiApi.getUserName(doc.getContentAuthor(), false));
        }
        calendar = Calendar.getInstance();
        calendar.setTime(doc.getContentUpdateDate());
        page.setModified(calendar);
        page.setComment(doc.getComment());
        page.setContent(doc.getContent());
        if (self != null) {
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        if ((xwikiClass = doc.getxWikiClass()) != null) {
            String classUri = DomainObjectFactory.uri(baseUri, ClassResource.class, doc.getWiki(), xwikiClass.getName());
            Link classLink = objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            page.getLinks().add(classLink);
        }
        return page;
    }

    public static HistorySummary createHistorySummary(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, String pageName, String language, Version version, String modifier, Date modified, String comment, XWiki xwikiApi, Boolean withPrettyNames) {
        HistorySummary historySummary = objectFactory.createHistorySummary();
        String pageId = Utils.getPageId(wikiName, spaceName, pageName);
        historySummary.setPageId(pageId);
        historySummary.setWiki(wikiName);
        historySummary.setSpace(spaceName);
        historySummary.setName(pageName);
        historySummary.setVersion(version.toString());
        historySummary.setMajorVersion(version.at(0));
        historySummary.setMinorVersion(version.at(1));
        historySummary.setComment(comment);
        historySummary.setModifier(modifier);
        if (withPrettyNames.booleanValue()) {
            historySummary.setModifierName(xwikiApi.getUserName(modifier, false));
        }
        historySummary.setLanguage(language);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(modified);
        historySummary.setModified(calendar);
        if (language == null) {
            String pageUri = DomainObjectFactory.uri(baseUri, PageVersionResource.class, wikiName, spaceName, pageName, version);
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        } else {
            String pageUri = DomainObjectFactory.uri(baseUri, PageTranslationVersionResource.class, wikiName, spaceName, pageName, language, version);
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        }
        return historySummary;
    }

    private static void fillAttachment(org.xwiki.rest.model.jaxb.Attachment attachment, ObjectFactory objectFactory, URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, XWiki xwikiApi, Boolean withPrettyNames) {
        Document doc = xwikiAttachment.getDocument();
        attachment.setId(String.format("%s@%s", doc.getPrefixedFullName(), xwikiAttachment.getFilename()));
        attachment.setName(xwikiAttachment.getFilename());
        attachment.setSize(xwikiAttachment.getFilesize());
        attachment.setVersion(xwikiAttachment.getVersion());
        attachment.setPageId(doc.getPrefixedFullName());
        attachment.setPageVersion(doc.getVersion());
        attachment.setMimeType(xwikiAttachment.getMimeType());
        attachment.setAuthor(xwikiAttachment.getAuthor());
        if (withPrettyNames.booleanValue()) {
            attachment.setAuthorName(xwikiApi.getUserName(xwikiAttachment.getAuthor(), false));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(xwikiAttachment.getDate());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        String pageUri = DomainObjectFactory.uri(baseUri, PageResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        attachment.getLinks().add(pageLink);
    }

    public static org.xwiki.rest.model.jaxb.Attachment createAttachment(ObjectFactory objectFactory, URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, XWiki xwikiApi, Boolean withPrettyNames) {
        org.xwiki.rest.model.jaxb.Attachment attachment = objectFactory.createAttachment();
        DomainObjectFactory.fillAttachment(attachment, objectFactory, baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl, xwikiApi, withPrettyNames);
        Document doc = xwikiAttachment.getDocument();
        String attachmentUri = DomainObjectFactory.uri(baseUri, AttachmentResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), xwikiAttachment.getFilename());
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    public static org.xwiki.rest.model.jaxb.Attachment createAttachmentAtVersion(ObjectFactory objectFactory, URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, XWiki xwikiApi, Boolean withPrettyNames) {
        org.xwiki.rest.model.jaxb.Attachment attachment = new org.xwiki.rest.model.jaxb.Attachment();
        DomainObjectFactory.fillAttachment(attachment, objectFactory, baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl, xwikiApi, withPrettyNames);
        Document doc = xwikiAttachment.getDocument();
        String attachmentUri = DomainObjectFactory.uri(baseUri, AttachmentVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), xwikiAttachment.getFilename(), xwikiAttachment.getVersion());
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    public static Comment createComment(ObjectFactory objectFactory, URI baseUri, Document doc, Object xwikiComment, XWiki xwikiApi, Boolean withPrettyNames) {
        Comment comment = objectFactory.createComment();
        comment.setId(xwikiComment.getNumber());
        Property property = xwikiComment.getProperty("author");
        if (property != null) {
            comment.setAuthor((String)property.getValue());
            if (withPrettyNames.booleanValue()) {
                comment.setAuthorName(xwikiApi.getUserName((String)property.getValue(), false));
            }
        }
        if ((property = xwikiComment.getProperty("date")) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)property.getValue());
            comment.setDate(calendar);
        }
        if ((property = xwikiComment.getProperty("highlight")) != null) {
            comment.setHighlight((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("comment")) != null) {
            comment.setText((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("replyto")) != null) {
            comment.setReplyTo((Integer)property.getValue());
        }
        String pageUri = DomainObjectFactory.uri(baseUri, PageResource.class, doc.getWiki(), doc.getSpace(), doc.getName());
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        comment.getLinks().add(pageLink);
        return comment;
    }

    private static void fillObjectSummary(ObjectSummary objectSummary, ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        objectSummary.setId(String.format("%s:%s", doc.getPrefixedFullName(), xwikiObject.getGuid()));
        objectSummary.setGuid(xwikiObject.getGuid());
        objectSummary.setPageId(doc.getPrefixedFullName());
        objectSummary.setPageVersion(doc.getVersion());
        objectSummary.setPageAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            objectSummary.setPageAuthorName(xwikiApi.getUserName(doc.getAuthor(), false));
        }
        objectSummary.setWiki(doc.getWiki());
        objectSummary.setSpace(doc.getSpace());
        objectSummary.setPageName(doc.getName());
        objectSummary.setClassName(xwikiObject.getClassName());
        objectSummary.setNumber(xwikiObject.getNumber());
        String[] propertyNames = xwikiObject.getPropertyNames();
        if (propertyNames.length > 0) {
            objectSummary.setHeadline(xwikiObject.get(propertyNames[0]).toFormString());
        }
    }

    public static ObjectSummary createObjectSummary(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        ObjectSummary objectSummary = objectFactory.createObjectSummary();
        DomainObjectFactory.fillObjectSummary(objectSummary, objectFactory, baseUri, doc, xwikiObject, xwikiApi, withPrettyNames);
        Link objectLink = DomainObjectFactory.getObjectLink(objectFactory, baseUri, doc, xwikiObject, useVersion, "http://www.xwiki.org/rel/object");
        objectSummary.getLinks().add(objectLink);
        String propertiesUri = useVersion ? DomainObjectFactory.uri(baseUri, ObjectPropertiesAtPageVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()) : DomainObjectFactory.uri(baseUri, ObjectPropertiesResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber());
        Link propertyLink = objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        objectSummary.getLinks().add(propertyLink);
        return objectSummary;
    }

    public static org.xwiki.rest.model.jaxb.Object createObject(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion, XWiki xwikiApi, Boolean withPrettyNames) throws XWikiException {
        org.xwiki.rest.model.jaxb.Object object = objectFactory.createObject();
        DomainObjectFactory.fillObjectSummary((ObjectSummary)object, objectFactory, baseUri, doc, xwikiObject, xwikiApi, withPrettyNames);
        BaseClass xwikiClass = xwikiObject.getXClass(xwikiContext);
        for (java.lang.Object propertyClassObject : xwikiClass.getProperties()) {
            ListClass listClass;
            List allowedValueList;
            PropertyClass propertyClass = (PropertyClass)propertyClassObject;
            org.xwiki.rest.model.jaxb.Property property = objectFactory.createProperty();
            for (java.lang.Object o : propertyClass.getProperties()) {
                BaseProperty baseProperty = (BaseProperty)o;
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName(baseProperty.getName());
                if (baseProperty.getValue() != null) {
                    attribute.setValue(baseProperty.getValue().toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            if (propertyClass instanceof ListClass && !(allowedValueList = (listClass = (ListClass)propertyClass).getList(xwikiContext)).isEmpty()) {
                Formatter f = new Formatter();
                for (int i = 0; i < allowedValueList.size(); ++i) {
                    if (i != allowedValueList.size() - 1) {
                        f.format("%s,", allowedValueList.get(i).toString());
                        continue;
                    }
                    f.format("%s", allowedValueList.get(i).toString());
                }
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName("allowedValues");
                attribute.setValue(f.toString());
                property.getAttributes().add(attribute);
            }
            property.setName(propertyClass.getName());
            property.setType(propertyClass.getClassType());
            if (xwikiObject.get(propertyClass.getName()) != null) {
                property.setValue(xwikiObject.get(propertyClass.getName()).toFormString());
            } else {
                property.setValue("");
            }
            String propertyUri = useVersion ? DomainObjectFactory.uri(baseUri, ObjectPropertyAtPageVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()) : DomainObjectFactory.uri(baseUri, ObjectPropertyResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName());
            Link propertyLink = objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            object.getProperties().add(property);
        }
        Link objectLink = DomainObjectFactory.getObjectLink(objectFactory, baseUri, doc, xwikiObject, useVersion, "self");
        object.getLinks().add(objectLink);
        return object;
    }

    private static Link getObjectLink(ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, String relation) {
        String objectUri = useVersion ? DomainObjectFactory.uri(baseUri, ObjectAtPageVersionResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()) : DomainObjectFactory.uri(baseUri, ObjectResource.class, doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber());
        Link objectLink = objectFactory.createLink();
        objectLink.setHref(objectUri);
        objectLink.setRel(relation);
        return objectLink;
    }

    public static org.xwiki.rest.model.jaxb.Class createClass(ObjectFactory objectFactory, URI baseUri, String wikiName, Class xwikiClass) {
        org.xwiki.rest.model.jaxb.Class clazz = objectFactory.createClass();
        clazz.setId(xwikiClass.getName());
        clazz.setName(xwikiClass.getName());
        for (Element xwikiPropertyClassObject : xwikiClass.getProperties()) {
            com.xpn.xwiki.api.PropertyClass xwikiPropertyClass = (com.xpn.xwiki.api.PropertyClass)xwikiPropertyClassObject;
            org.xwiki.rest.model.jaxb.Property property = objectFactory.createProperty();
            property.setName(xwikiPropertyClass.getName());
            property.setType(xwikiPropertyClass.getxWikiClass().getName());
            for (Element xwikiPropertyObject : xwikiPropertyClass.getProperties()) {
                Property xwikiProperty = (Property)xwikiPropertyObject;
                java.lang.Object value = xwikiProperty.getValue();
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName(xwikiProperty.getName());
                if (value != null) {
                    attribute.setValue(value.toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            String propertyUri = DomainObjectFactory.uri(baseUri, ClassPropertyResource.class, wikiName, xwikiClass.getName(), xwikiPropertyClass.getName());
            Link propertyLink = objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            clazz.getProperties().add(property);
        }
        String classUri = DomainObjectFactory.uri(baseUri, ClassResource.class, wikiName, xwikiClass.getName());
        Link classLink = objectFactory.createLink();
        classLink.setHref(classUri);
        classLink.setRel("self");
        clazz.getLinks().add(classLink);
        String propertiesUri = DomainObjectFactory.uri(baseUri, ClassPropertiesResource.class, wikiName, xwikiClass.getName());
        Link propertyLink = objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        clazz.getLinks().add(propertyLink);
        String objectsUri = DomainObjectFactory.uri(baseUri, AllObjectsForClassNameResource.class, wikiName, xwikiClass.getName());
        Link objectsLink = objectFactory.createLink();
        objectsLink.setHref(objectsUri);
        objectsLink.setRel("http://www.xwiki.org/rel/objects");
        clazz.getLinks().add(objectsLink);
        return clazz;
    }

    private static String uri(URI baseURI, java.lang.Class<?> resourceClass, java.lang.Object ... pathElements) {
        return Utils.createURI(baseURI, resourceClass, pathElements).toString();
    }
}

