/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.api.Document;
import java.util.List;
import java.util.regex.Pattern;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.pages.PagesResource;

@Component(value="org.xwiki.rest.internal.resources.pages.PagesResourceImpl")
public class PagesResourceImpl
extends XWikiResource
implements PagesResource {
    public Pages getPages(String wikiName, String spaceName, Integer start, Integer number, String parentFilterExpression, String order, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        Pages pages = this.objectFactory.createPages();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            Query query = "date".equals(order) ? this.queryManager.createQuery("select doc.name from Document doc where doc.space=:space and language='' order by doc.date desc", "xwql") : this.queryManager.getNamedQuery("getSpaceDocsName");
            List pageNames = query.addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "hidden")).bindValue("space", (Object)spaceName).setOffset(start.intValue()).setLimit(number.intValue()).execute();
            Pattern parentFilter = null;
            if (parentFilterExpression != null) {
                parentFilter = parentFilterExpression.equals("null") ? Pattern.compile("") : Pattern.compile(parentFilterExpression);
            }
            for (String pageName : pageNames) {
                String pageFullName = Utils.getPageId(wikiName, spaceName, pageName);
                if (!Utils.getXWikiApi(this.componentManager).exists(pageFullName)) {
                    this.logger.warning(String.format("[Page '%s' appears to be in space '%s' but no information is available.]", pageName, spaceName));
                    continue;
                }
                Document doc = Utils.getXWikiApi(this.componentManager).getDocument(pageFullName);
                if (doc == null) continue;
                boolean add = true;
                Document parent = Utils.getParentDocument(doc, Utils.getXWikiApi(this.componentManager));
                if (parentFilter != null) {
                    String parentId = "";
                    if (parent != null && !parent.isNew()) {
                        parentId = parent.getPrefixedFullName();
                    }
                    add = parentFilter.matcher(parentId).matches();
                }
                if (!add) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return pages;
    }
}

