/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.tags;

import java.util.Collections;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.tags.PagesForTagsResource;
import org.xwiki.rest.resources.tags.TagsResource;

@Component(value="org.xwiki.rest.internal.resources.tags.TagsResourceImpl")
public class TagsResourceImpl
extends XWikiResource
implements TagsResource {
    public Tags getTags(String wikiName) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Tags tags = this.objectFactory.createTags();
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            List<String> tagNames = this.getAllTags();
            for (String tagName : tagNames) {
                Tag tag = this.objectFactory.createTag();
                tag.setName(tagName);
                String tagUri = Utils.createURI(this.uriInfo.getBaseUri(), PagesForTagsResource.class, wikiName, tagName).toString();
                Link tagLink = this.objectFactory.createLink();
                tagLink.setHref(tagUri);
                tagLink.setRel("http://www.xwiki.org/rel/tag");
                tag.getLinks().add(tagLink);
                tags.getTags().add(tag);
            }
            Tags tags2 = tags;
            return tags2;
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    private List<String> getAllTags() throws QueryException {
        String query = "select distinct elements(prop.list) from BaseObject as obj, DBStringListProperty as prop where obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags'";
        List tags = this.queryManager.createQuery(query, "hql").execute();
        Collections.sort(tags, String.CASE_INSENSITIVE_ORDER);
        return tags;
    }
}

