/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.packaging.PackageAPI;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.wikis.WikiResource;

@Component(value="org.xwiki.rest.internal.resources.wikis.WikiResourceImpl")
public class WikiResourceImpl
extends XWikiResource
implements WikiResource {
    public Wiki get(String wikiName) throws XWikiRestException {
        try {
            if (this.wikiExists(wikiName)) {
                return DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wikiName);
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Wiki importXAR(String wikiName, Boolean backup, String history, InputStream is) throws XWikiRestException {
        try {
            if (!this.wikiExists(wikiName)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            XWikiContext xwikiContext = this.getXWikiContext();
            PackageAPI importer = (PackageAPI)xwikiContext.getWiki().getPluginApi("package", xwikiContext);
            if (importer == null) {
                throw new XWikiException(9, 9001, "Can't access Package plugin API. Generally mean you don't have enough rights.");
            }
            String database = xwikiContext.getWikiId();
            try {
                xwikiContext.setWikiId(wikiName);
                importer.setBackupPack(backup.booleanValue());
                importer.Import(is);
                HistoryOptions historyOption = this.parseHistoryOption(history, HistoryOptions.ADD);
                switch (historyOption) {
                    case RESET: {
                        importer.setPreserveVersion(false);
                        importer.setWithVersions(false);
                        break;
                    }
                    case REPLACE: {
                        importer.setPreserveVersion(false);
                        importer.setWithVersions(true);
                        break;
                    }
                    default: {
                        importer.setPreserveVersion(true);
                        importer.setWithVersions(false);
                    }
                }
                importer.setBackupPack(backup.booleanValue());
                if (importer.install() == 0) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
            finally {
                xwikiContext.setWikiId(database);
            }
            return DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wikiName);
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    protected boolean wikiExists(String wikiName) throws XWikiException {
        List databaseNames = Utils.getXWiki(this.componentManager).getVirtualWikisDatabaseNames(Utils.getXWikiContext(this.componentManager));
        if (databaseNames.isEmpty()) {
            databaseNames.add("xwiki");
        }
        for (String databaseName : databaseNames) {
            if (!databaseName.equals(wikiName)) continue;
            return true;
        }
        return false;
    }

    protected HistoryOptions parseHistoryOption(String value, HistoryOptions defaultValue) {
        try {
            if (value != null) {
                return HistoryOptions.valueOf(value.toUpperCase());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static enum HistoryOptions {
        ADD,
        RESET,
        REPLACE;

    }
}

