/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.security.Principal;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.security.SecretVerifier;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.internal.Utils;

public class XWikiSecretVerifier
extends SecretVerifier {
    private ComponentManager componentManager;
    private Context context;

    public XWikiSecretVerifier(Context context, ComponentManager manager) {
        this.context = context;
        this.componentManager = manager;
    }

    public boolean verify(String identifier, char[] secret) throws IllegalArgumentException {
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        XWiki xwiki = Utils.getXWiki(this.componentManager);
        try {
            Principal principal;
            Principal principal2 = principal = secret == null ? null : xwiki.getAuthService().authenticate(identifier, new String(secret), xwikiContext);
            if (principal != null) {
                String xwikiUser = principal.getName();
                xwikiContext.setUser(xwikiUser);
                this.context.getLogger().log(Level.FINE, String.format("Authenticated as '%s'.", identifier));
                return true;
            }
        }
        catch (XWikiException e) {
            this.context.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
        }
        this.context.getLogger().log(Level.WARNING, String.format("Cannot authenticate '%s'.", identifier));
        return false;
    }
}

