/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusListener
implements SchedulerListener,
JobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusListener.class);

    public void jobScheduled(Trigger trigger) {
        LOGGER.info("Task [{}] scheduled", (Object)trigger.getJobName());
    }

    public void jobUnscheduled(String name, String group) {
        LOGGER.info("Task [{}] unscheduled", (Object)name);
    }

    public void triggerFinalized(Trigger trigger) {
    }

    public void triggersPaused(String trigger, String group) {
    }

    public void triggersResumed(String trigger, String group) {
    }

    public void jobsPaused(String name, String group) {
        LOGGER.info("Task [{}] paused", (Object)name);
    }

    public void jobsResumed(String name, String group) {
        LOGGER.info("Task [{}] resumed", (Object)name);
    }

    public void schedulerError(String message, SchedulerException error) {
        LOGGER.error(message, (Throwable)error);
    }

    public void schedulerShutdown() {
        LOGGER.warn("Scheduler is shutting down");
    }

    public String getName() {
        return "StatusListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        LOGGER.info("Task [{}] is about to be executed", (Object)context.getJobDetail().getName());
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException e) {
        LOGGER.info("Task [{}] executed: ", (Object)context.getJobDetail().getName(), (Object)e);
    }
}

