/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.scheduler.JobState;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginApi;
import com.xpn.xwiki.plugin.scheduler.SchedulerPluginException;
import com.xpn.xwiki.plugin.scheduler.StatusListener;
import com.xpn.xwiki.plugin.scheduler.XWikiServletRequestStub;
import com.xpn.xwiki.plugin.scheduler.XWikiServletResponseStub;
import com.xpn.xwiki.plugin.scheduler.internal.SchedulerJobClassDocumentInitializer;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiRequest;
import com.xpn.xwiki.web.XWikiResponse;
import com.xpn.xwiki.web.XWikiServletRequest;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptServiceManager;

public class SchedulerPlugin
extends XWikiDefaultPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerPlugin.class);
    @Deprecated
    public static final String XWIKI_JOB_CLASS = "XWiki.SchedulerJobClass";
    public static final EntityReference XWIKI_JOB_CLASSREFERENCE = SchedulerJobClassDocumentInitializer.XWIKI_JOB_CLASSREFERENCE;
    private Scheduler scheduler;

    public SchedulerPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public void init(XWikiContext context) {
        Thread thread = new Thread((Runnable)new ExecutionContextRunnable(new Runnable(){

            @Override
            public void run() {
                SchedulerPlugin.this.initAsync();
            }
        }, Utils.getComponentManager()));
        thread.setName("XWiki Scheduler initialization");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAsync() {
        XWikiContext xcontext = (XWikiContext)((Provider)Utils.getComponent((Type)XWikiContext.TYPE_PROVIDER)).get();
        try {
            String initialDb = !xcontext.getWikiId().equals("") ? xcontext.getWikiId() : xcontext.getMainXWiki();
            List wikiServers = new ArrayList();
            try {
                wikiServers = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            }
            catch (Exception e) {
                LOGGER.error("error getting list of wiki servers!", (Throwable)e);
            }
            System.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            System.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
            this.setScheduler(this.getDefaultSchedulerInstance());
            this.setStatusListener();
            this.getScheduler().start();
            try {
                for (String wikiName : wikiServers) {
                    xcontext.setWikiId(wikiName);
                    this.restoreExistingJobs(xcontext);
                }
            }
            finally {
                xcontext.setWikiId(initialDb);
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("Failed to start the scheduler", (Throwable)e);
        }
        catch (SchedulerPluginException e) {
            LOGGER.error("Failed to initialize the scheduler", (Throwable)((Object)e));
        }
    }

    private XWikiContext prepareJobStubContext(BaseObject job, XWikiContext context) throws SchedulerPluginException {
        XWikiURLFactory xurf;
        String cLang;
        boolean jobNeedsUpdate = false;
        String cUser = job.getStringValue("contextUser");
        if (cUser.equals("")) {
            cUser = context.getUser();
            job.setStringValue("contextUser", cUser);
            jobNeedsUpdate = true;
        }
        if ((cLang = job.getStringValue("contextLang")).equals("")) {
            cLang = context.getLanguage();
            job.setStringValue("contextLang", cLang);
            jobNeedsUpdate = true;
        }
        String iDb = context.getWikiId();
        String cDb = job.getStringValue("contextDatabase");
        if (cDb.equals("") || !cDb.equals(iDb)) {
            cDb = context.getWikiId();
            job.setStringValue("contextDatabase", cDb);
            jobNeedsUpdate = true;
        }
        if (jobNeedsUpdate) {
            try {
                context.setWikiId(cDb);
                XWikiDocument jobHolder = context.getWiki().getDocument(job.getName(), context);
                jobHolder.setMinorEdit(true);
                context.getWiki().saveDocument(jobHolder, context);
            }
            catch (XWikiException e) {
                throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
            }
            finally {
                context.setWikiId(iDb);
            }
        }
        XWikiContext scontext = context.clone();
        scontext.setWiki(context.getWiki());
        context.getWiki().getStore().cleanUp(context);
        XWikiServletRequestStub dummy = new XWikiServletRequestStub();
        dummy.setHost(context.getRequest().getHeader("x-forwarded-host"));
        dummy.setScheme(context.getRequest().getScheme());
        dummy.setContextPath(context.getRequest().getContextPath());
        XWikiServletRequest request = new XWikiServletRequest((HttpServletRequest)dummy);
        scontext.setRequest((XWikiRequest)request);
        XWikiServletResponseStub stub = new XWikiServletResponseStub();
        scontext.setResponse((XWikiResponse)stub);
        scontext.setUser(cUser);
        scontext.setLanguage(cLang);
        scontext.setWikiId(cDb);
        scontext.setMainXWiki(context.getMainXWiki());
        if (scontext.getURL() == null) {
            try {
                scontext.setURL(new URL("http://www.mystuburl.com/"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((xurf = context.getURLFactory()) == null) {
            xurf = context.getWiki().getURLFactoryService().createURLFactory(context.getMode(), context);
        }
        scontext.setURLFactory(xurf);
        try {
            XWikiDocument cDoc = context.getWiki().getDocument(job.getDocumentReference(), context);
            scontext.setDoc(cDoc);
        }
        catch (Exception e) {
            throw new SchedulerPluginException(90011, "Failed to prepare context for job with job name " + job.getStringValue("jobName"), e);
        }
        return scontext;
    }

    private void restoreExistingJobs(XWikiContext context) {
        String hql = ", BaseObject as obj where obj.name=doc.fullName and obj.className='XWiki.SchedulerJobClass'";
        try {
            List jobDocReferences = context.getWiki().getStore().searchDocumentReferences(hql, context);
            for (DocumentReference docReference : jobDocReferences) {
                try {
                    XWikiDocument jobDoc = context.getWiki().getDocument(docReference, context);
                    BaseObject jobObj = jobDoc.getXObject(XWIKI_JOB_CLASSREFERENCE);
                    String status = jobObj.getStringValue("status");
                    if (status.equals("Normal") || status.equals("Paused")) {
                        this.scheduleJob(jobObj, context);
                    }
                    if (!status.equals("Paused")) continue;
                    this.pauseJob(jobObj, context);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to restore job with in document [{}] and wiki [{}]", new Object[]{docReference, context.getWikiId(), e});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore existing scheduler jobs in wiki [{}]", (Object)context.getWikiId(), (Object)e);
        }
    }

    public JobState getJobStatus(BaseObject object, XWikiContext context) throws SchedulerException {
        int state = this.getScheduler().getTriggerState(this.getObjectUniqueId(object, context), "DEFAULT");
        return new JobState(state);
    }

    public boolean scheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        boolean scheduled = true;
        try {
            JobDataMap data = new JobDataMap();
            String xjob = this.getObjectUniqueId(object, context);
            JobDetail job = new JobDetail(xjob, "DEFAULT", Class.forName(object.getStringValue("jobClass")));
            CronTrigger trigger = new CronTrigger(xjob, "DEFAULT", xjob, "DEFAULT", object.getStringValue("cron"));
            XWikiContext stubContext = this.prepareJobStubContext(object, context);
            data.put((Object)"context", (Object)stubContext);
            data.put((Object)"xcontext", (Object)stubContext);
            data.put((Object)"xwiki", (Object)new XWiki(context.getWiki(), stubContext));
            data.put((Object)"xjob", (Object)object);
            data.put((Object)"services", Utils.getComponent(ScriptServiceManager.class));
            job.setJobDataMap(data);
            this.getScheduler().addJob(job, true);
            JobState status = this.getJobStatus(object, context);
            switch (status.getState()) {
                case 1: {
                    break;
                }
                case 0: {
                    if (this.getTrigger(object, context).compareTo((Object)trigger) != 0) {
                        LOGGER.debug("Reschedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    }
                    this.getScheduler().rescheduleJob(trigger.getName(), trigger.getGroup(), (Trigger)trigger);
                    break;
                }
                case -1: {
                    LOGGER.debug("Schedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    LOGGER.info("XWiki Job Status: [{}]", (Object)object.getStringValue("status"));
                    if (object.getStringValue("status").equals("Paused")) {
                        this.getScheduler().pauseJob(xjob, "DEFAULT");
                        this.saveStatus("Paused", object, context);
                        break;
                    }
                    this.saveStatus("Normal", object, context);
                    break;
                }
                default: {
                    LOGGER.debug("Schedule Job: [{}]", (Object)object.getStringValue("jobName"));
                    this.getScheduler().scheduleJob((Trigger)trigger);
                    this.saveStatus("Normal", object, context);
                    break;
                }
            }
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90004, "Error while scheduling job " + object.getStringValue("jobName"), e);
        }
        catch (ParseException e) {
            throw new SchedulerPluginException(90005, "Error while parsing cron expression for job " + object.getStringValue("jobName"), e);
        }
        catch (ClassNotFoundException e) {
            throw new SchedulerPluginException(90006, "Error while loading job class for job : " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving job status for job : " + object.getStringValue("jobName"), e);
        }
        return scheduled;
    }

    public void pauseJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().pauseJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Paused", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to pause job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90002, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void resumeJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().resumeJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("Normal", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to resume job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90003, "Error occured while trying to save status of job " + object.getStringValue("jobName"), e);
        }
    }

    public void triggerJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().triggerJob(this.getObjectUniqueId(object, context), "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90012, "Error occured while trying to trigger job " + object.getStringValue("jobName"), e);
        }
    }

    public void unscheduleJob(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        try {
            this.getScheduler().deleteJob(this.getObjectUniqueId(object, context), "DEFAULT");
            this.saveStatus("None", object, context);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while unscheduling job " + object.getStringValue("jobName"), e);
        }
        catch (XWikiException e) {
            throw new SchedulerPluginException(90006, "Error while saving status of job " + object.getStringValue("jobName"), e);
        }
    }

    private Trigger getTrigger(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        Trigger trigger;
        String job = this.getObjectUniqueId(object, context);
        try {
            trigger = this.getScheduler().getTrigger(job, "DEFAULT");
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90006, "Error while getting trigger for job " + job, e);
        }
        if (trigger == null) {
            throw new SchedulerPluginException(90007, "Job does not exists");
        }
        return trigger;
    }

    public Date getPreviousFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getPreviousFireTime();
    }

    public Date getNextFireTime(BaseObject object, XWikiContext context) throws SchedulerPluginException {
        return this.getTrigger(object, context).getNextFireTime();
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SchedulerPluginApi((SchedulerPlugin)plugin, context);
    }

    public String getName() {
        return "scheduler";
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private synchronized Scheduler getDefaultSchedulerInstance() throws SchedulerPluginException {
        Scheduler scheduler;
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90007, "Error getting default Scheduler instance", e);
        }
        return scheduler;
    }

    private void setStatusListener() throws SchedulerPluginException {
        StatusListener listener = new StatusListener();
        try {
            this.getScheduler().addSchedulerListener((SchedulerListener)listener);
            this.getScheduler().addGlobalJobListener((JobListener)listener);
        }
        catch (SchedulerException e) {
            throw new SchedulerPluginException(90001, "Error while initializing the status listener", e);
        }
    }

    private void saveStatus(String status, BaseObject object, XWikiContext context) throws XWikiException {
        XWikiDocument jobHolder = context.getWiki().getDocument(object.getDocumentReference(), context);
        BaseObject job = jobHolder.getXObject(XWIKI_JOB_CLASSREFERENCE);
        job.setStringValue("status", status);
        jobHolder.setMinorEdit(true);
        context.getWiki().saveDocument(jobHolder, context);
    }

    private String getObjectUniqueId(BaseObject object, XWikiContext context) {
        return context.getWikiId() + ":" + object.getName() + "_" + object.getNumber();
    }
}

