/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.SchedulerJobSheet")
@Singleton
public class SchedulerJobClassDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    public static final String SHEET_NAME = "SchedulerJobSheet";
    public static final LocalDocumentReference XWIKI_JOB_CLASSREFERENCE = new LocalDocumentReference("XWiki", "SchedulerJobClass");
    private static final String FIELD_JOBNAME = "jobName";
    private static final String FIELD_JOBDESCRIPTION = "jobDescription";
    private static final String FIELD_JOBCLASS = "jobClass";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_CRON = "cron";
    private static final String FIELD_SCRIPT = "script";
    private static final String FIELD_CONTEXTUSER = "contextUser";
    private static final String FIELD_CONTEXTLANG = "contextLang";
    private static final String FIELD_CONTEXTDATABASE = "contextDatabase";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public SchedulerJobClassDocumentInitializer() {
        super("XWiki", XWIKI_JOB_CLASSREFERENCE.getName());
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = false;
        BaseClass baseClass = document.getXClass();
        needsUpdate |= baseClass.addTextField(FIELD_JOBNAME, "Job Name", 60);
        needsUpdate |= baseClass.addTextAreaField(FIELD_JOBDESCRIPTION, "Job Description", 45, 10);
        needsUpdate |= baseClass.addTextField(FIELD_JOBCLASS, "Job Class", 60);
        needsUpdate |= baseClass.addTextField(FIELD_STATUS, "Status", 30);
        needsUpdate |= baseClass.addTextField(FIELD_CRON, "Cron Expression", 30);
        needsUpdate |= baseClass.addTextAreaField(FIELD_SCRIPT, "Job Script", 60, 10);
        TextAreaClass scriptField = (TextAreaClass)baseClass.getField(FIELD_SCRIPT);
        if (!scriptField.getEditor().equals("puretext")) {
            scriptField.setStringValue("editor", "PureText");
            needsUpdate = true;
        }
        needsUpdate |= baseClass.addTextField(FIELD_CONTEXTUSER, "Job execution context user", 30);
        needsUpdate |= baseClass.addTextField(FIELD_CONTEXTLANG, "Job execution context lang", 30);
        needsUpdate |= baseClass.addTextField(FIELD_CONTEXTDATABASE, "Job execution context database", 30);
        needsUpdate |= this.setClassDocumentFields(document, "XWiki Scheduler Job Class");
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", SHEET_NAME);
            needsUpdate |= this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return needsUpdate;
    }
}

