/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler.internal;

import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusListener
implements SchedulerListener,
JobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusListener.class);

    public void jobScheduled(Trigger trigger) {
        LOGGER.info("Task [{}] scheduled", (Object)trigger.getKey());
    }

    public void jobUnscheduled(TriggerKey key) {
        LOGGER.info("Task [{}] unscheduled", (Object)key);
    }

    public void triggerFinalized(Trigger trigger) {
    }

    public void triggerPaused(TriggerKey triggerKey) {
    }

    public void triggerResumed(TriggerKey triggerKey) {
    }

    public void jobPaused(JobKey jobKey) {
        LOGGER.info("Task [{}] paused", (Object)jobKey);
    }

    public void jobResumed(JobKey jobKey) {
        LOGGER.info("Task [{}] resumed", (Object)jobKey);
    }

    public void schedulerError(String message, SchedulerException error) {
        LOGGER.error(message, (Throwable)error);
    }

    public void schedulerShutdown() {
        LOGGER.warn("Scheduler is shutting down");
    }

    public String getName() {
        return "StatusListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        LOGGER.info("Task [{}] is about to be executed", (Object)context.getJobDetail().getKey());
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException e) {
        LOGGER.info("Task [{}] executed: ", (Object)context.getJobDetail().getKey(), (Object)e);
    }

    public void triggersPaused(String triggerGroup) {
    }

    public void triggersResumed(String triggerGroup) {
    }

    public void jobAdded(JobDetail jobDetail) {
    }

    public void jobDeleted(JobKey jobKey) {
    }

    public void jobsPaused(String jobGroup) {
    }

    public void jobsResumed(String jobGroup) {
    }

    public void schedulerInStandbyMode() {
    }

    public void schedulerStarted() {
    }

    public void schedulerStarting() {
    }

    public void schedulerShuttingdown() {
    }

    public void schedulingDataCleared() {
    }
}

