/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.AbstractIndexData;
import com.xpn.xwiki.plugin.lucene.IndexFields;
import com.xpn.xwiki.web.Utils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.syntax.Syntax;

public abstract class AbstractDocumentData
extends AbstractIndexData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDocumentData.class);
    protected static final float ID_BOOST = 0.1f;
    protected static final float LANGUAGE_BOOST = 0.1f;
    protected static final float TYPE_BOOST = 0.1f;
    protected static final float WIKI_BOOST = 0.1f;
    protected static final float SPACE_BOOST = 0.5f;
    protected static final float NAME_BOOST = 2.5f;
    protected static final float FULL_NAME_BOOST = 2.0f;
    protected static final float TITLE_BOOST = 3.0f;
    protected static final float CONTENT_BOOST = 2.0f;
    protected static final float CREATOR_BOOST = 0.25f;
    protected static final float AUTHOR_BOOST = 0.25f;
    protected static final float CREATION_DATE_BOOST = 0.2f;
    protected static final float DATE_BOOST = 0.1f;
    private String version;
    private String documentTitle;
    private String author;
    private String creator;
    private String language;
    private Date creationDate;
    private Date modificationDate;

    public AbstractDocumentData(String type, XWikiDocument doc, XWikiContext context, boolean deleted) {
        super(type, (EntityReference)doc.getDocumentReference(), deleted);
        this.setVersion(doc.getVersion());
        this.setDocumentTitle(doc.getRenderedTitle(Syntax.PLAIN_1_0, context));
        this.setLanguage(doc.getLanguage());
    }

    @Override
    public void addDataToLuceneDocument(Document luceneDoc, XWikiContext context) throws XWikiException {
        XWikiDocument doc = context.getWiki().getDocument(this.getDocumentReference(), context);
        if (this.getLanguage() != null && !this.getLanguage().equals("")) {
            doc = doc.getTranslatedDocument(this.getLanguage(), context);
        }
        this.addDocumentDataToLuceneDocument(luceneDoc, doc, context);
    }

    public void addDocumentDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        AbstractDocumentData.addFieldToDocument("_docid", this.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        AbstractDocumentData.addFieldToDocument("lang", this.getLanguage(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        AbstractDocumentData.addFieldToDocument("wiki", this.getWiki(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        if (StringUtils.isNotBlank((CharSequence)this.author)) {
            AbstractDocumentData.addFieldToDocument("author", this.author, Field.Store.YES, Field.Index.NOT_ANALYZED, 0.25f, luceneDoc);
        }
        if (StringUtils.isNotBlank((CharSequence)this.creator)) {
            AbstractDocumentData.addFieldToDocument("creator", this.creator, Field.Store.YES, Field.Index.NOT_ANALYZED, 0.25f, luceneDoc);
        }
        if (this.getType() != null) {
            AbstractDocumentData.addFieldToDocument("type", this.getType(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        }
        if (this.modificationDate != null) {
            AbstractDocumentData.addFieldToDocument("date", IndexFields.dateToString(this.modificationDate), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        }
        if (this.creationDate != null) {
            AbstractDocumentData.addFieldToDocument("creationdate", IndexFields.dateToString(this.creationDate), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.2f, luceneDoc);
        }
        if (StringUtils.isNotBlank((CharSequence)this.documentTitle)) {
            AbstractDocumentData.addFieldToDocument("title", this.documentTitle, Field.Store.YES, Field.Index.ANALYZED, 3.0f, luceneDoc);
        }
        AbstractDocumentData.addFieldToDocument("name", this.getDocumentName(), Field.Store.YES, Field.Index.ANALYZED, 2.5f, luceneDoc);
        AbstractDocumentData.addFieldToDocument("space", this.getDocumentSpace(), Field.Store.YES, Field.Index.ANALYZED, 0.5f, luceneDoc);
        AbstractDocumentData.addFieldToDocument("web", this.getDocumentSpace(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.1f, luceneDoc);
        AbstractDocumentData.addFieldToDocument("fullname", this.getDocumentFullName(), Field.Store.YES, Field.Index.ANALYZED, 2.0f, luceneDoc);
        try {
            String ft = this.getFullText(doc, context);
            if (ft != null) {
                AbstractDocumentData.addFieldToDocument("ft", ft, Field.Store.NO, Field.Index.ANALYZED, 2.0f, luceneDoc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error extracting fulltext for document [{}]", (Object)this.toString(), (Object)e);
        }
    }

    @Override
    public String getId() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.getFullName());
        retval.append(".");
        retval.append(this.getLanguage());
        return retval.toString();
    }

    @Override
    public Term getTerm() {
        return new Term("_docid", this.getId());
    }

    @Override
    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuilder sb = new StringBuilder();
        this.getFullText(sb, doc, context);
        return sb.toString();
    }

    @Override
    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.getEntityReference();
    }

    @Override
    public String getDocumentName() {
        return this.getEntityName(EntityType.DOCUMENT);
    }

    @Override
    public String getDocumentSpace() {
        return this.getEntityName(EntityType.SPACE);
    }

    @Override
    public String getWiki() {
        return this.getEntityName(EntityType.WIKI);
    }

    @Override
    public String getDocumentFullName() {
        return (String)((EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.class, (String)"local")).serialize(this.getEntityReference(), new Object[0]);
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getFullName() {
        return (String)((EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.class)).serialize(this.getEntityReference(), new Object[0]);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String lang) {
        this.language = !StringUtils.isEmpty((CharSequence)lang) ? lang : "default";
    }

    @Override
    public String toString() {
        return this.getId();
    }

    protected static void addFieldToDocument(String fieldName, String value, Field.Store howToStore, Field.Index howToIndex, float boost, Document luceneDoc) {
        Field f = new Field(fieldName, value, howToStore, howToIndex);
        f.setBoost(boost);
        luceneDoc.add((Fieldable)f);
    }
}

