/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.lucene.IndexFields;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResult {
    private String id;
    private float score;
    private String title;
    private String name;
    private String wiki;
    private String space;
    private String fullName;
    private String url;
    private String filename;
    private String[] objects;
    private String type;
    private String author;
    private String language;
    private Date date;
    private Date creationDate;
    private String creator;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResult.class);

    public SearchResult(org.apache.lucene.document.Document doc, float score, XWiki xwiki) {
        this.score = score;
        this.id = doc.get("_docid");
        this.title = doc.get("title");
        this.name = doc.get("name");
        this.space = doc.get("space");
        this.wiki = doc.get("wiki");
        this.fullName = doc.get("fullname");
        this.type = doc.get("type");
        this.author = doc.get("author");
        this.creator = doc.get("creator");
        this.language = doc.get("lang");
        this.date = IndexFields.stringToDate(doc.get("date"));
        this.creationDate = IndexFields.stringToDate(doc.get("creationdate"));
        if ("attachment".equals(this.type)) {
            this.filename = doc.get("filename");
            String fullDocName = new StringBuffer(this.wiki).append(":").append(this.space).append(".").append(this.name).toString();
            try {
                Document document = xwiki.getDocument(fullDocName);
                if (document != null) {
                    this.url = document.getAttachmentURL(this.filename, "download");
                }
            }
            catch (XWikiException e) {
                LOGGER.error("error retrieving url for attachment [{}] of document [{}]", new Object[]{this.filename, fullDocName, e});
            }
        } else {
            this.objects = doc.getValues("object");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public float getScore() {
        return this.score;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    @Deprecated
    public String getWeb() {
        return this.space;
    }

    public String getSpace() {
        return this.space;
    }

    public String getLanguage() {
        return this.language;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getWiki() {
        return this.wiki;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String[] getObjects() {
        return this.objects;
    }

    public boolean isWikiContent() {
        return "wikipage".equals(this.type) || "attachment".equals(this.type);
    }
}

