/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.web.Utils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public abstract class AbstractIndexData {
    private String type;
    private boolean deleted;
    private EntityReference entityReference;

    public AbstractIndexData(String type, EntityReference entityReference, boolean deleted) {
        this.type = type;
        this.setEntityReference(entityReference);
        this.setDeleted(deleted);
    }

    public void addDataToLuceneDocument(Document luceneDoc, XWikiContext context) throws XWikiException {
    }

    public abstract String getId();

    public Term getTerm() {
        return new Term("_docid", this.getId());
    }

    public String getFullText(XWikiDocument doc, XWikiContext context) {
        StringBuilder sb = new StringBuilder();
        this.getFullText(sb, doc, context);
        return sb.toString();
    }

    protected abstract void getFullText(StringBuilder var1, XWikiDocument var2, XWikiContext var3);

    public String getType() {
        return this.type;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(EntityReference entityReference) {
        this.entityReference = entityReference;
    }

    protected String getEntityName(EntityType type) {
        EntityReference extract = this.getEntityReference().extractReference(type);
        return extract != null ? extract.getName() : null;
    }

    public String getDocumentName() {
        return this.getEntityName(EntityType.DOCUMENT);
    }

    public String getDocumentSpace() {
        return this.getEntityName(EntityType.SPACE);
    }

    public String getWiki() {
        return this.getEntityName(EntityType.WIKI);
    }

    public String getDocumentFullName() {
        return (String)((EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.class, (String)"local")).serialize(this.getEntityReference(), new Object[0]);
    }

    public String getFullName() {
        return (String)((EntityReferenceSerializer)Utils.getComponent(EntityReferenceSerializer.class)).serialize(this.getEntityReference(), new Object[0]);
    }

    public String toString() {
        return this.getId();
    }
}

