/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.util.AbstractXWikiRunnable;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.IndexOperation;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.api.SolrInstance;
import org.xwiki.search.solr.internal.job.IndexerJob;
import org.xwiki.search.solr.internal.job.IndexerRequest;
import org.xwiki.search.solr.internal.metadata.LengthSolrInputDocument;
import org.xwiki.search.solr.internal.metadata.SolrMetadataExtractor;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Singleton
@DisposePriority(value=500)
public class DefaultSolrIndexer
implements SolrIndexer,
Initializable,
Disposable,
Runnable {
    private static final ResolveQueueEntry RESOLVE_QUEUE_ENTRY_STOP = new ResolveQueueEntry(null, false, IndexOperation.STOP);
    private static final IndexQueueEntry INDEX_QUEUE_ENTRY_STOP = new IndexQueueEntry((String)null, IndexOperation.STOP);
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private Provider<SolrInstance> solrInstanceProvider;
    @Inject
    private SolrReferenceResolver solrRefereceResolver;
    @Inject
    private Execution execution;
    @Inject
    private ExecutionContextManager ecim;
    @Inject
    private JobExecutor jobs;
    private BlockingQueue<IndexQueueEntry> indexQueue;
    private BlockingQueue<ResolveQueueEntry> resolveQueue;
    private Thread indexThread;
    private Thread resolveThread;
    private boolean disposed;
    private volatile int batchSize;

    public void initialize() throws InitializationException {
        this.resolveQueue = new LinkedBlockingQueue<ResolveQueueEntry>();
        this.indexQueue = new LinkedBlockingQueue<IndexQueueEntry>(this.configuration.getIndexerQueueCapacity());
        this.resolveThread = new Thread((Runnable)((Object)new Resolver()));
        this.resolveThread.setName("XWiki Solr resolve thread");
        this.resolveThread.setDaemon(true);
        this.resolveThread.start();
        this.resolveThread.setPriority(4);
        this.indexThread = new Thread(this);
        this.indexThread.setName("XWiki Solr index thread");
        this.indexThread.setDaemon(true);
        this.indexThread.start();
        this.indexThread.setPriority(4);
    }

    public void dispose() throws ComponentLifecycleException {
        this.disposed = true;
        this.resolveQueue.clear();
        this.resolveQueue.offer(RESOLVE_QUEUE_ENTRY_STOP);
        this.indexQueue.clear();
        this.indexQueue.offer(INDEX_QUEUE_ENTRY_STOP);
    }

    @Override
    public void run() {
        this.logger.debug("Start SOLR indexer thread");
        while (!Thread.interrupted()) {
            IndexQueueEntry queueEntry = null;
            try {
                queueEntry = this.indexQueue.take();
            }
            catch (InterruptedException e) {
                this.logger.warn("The SOLR index thread has been interrupted", (Throwable)e);
                queueEntry = INDEX_QUEUE_ENTRY_STOP;
            }
            if (this.processBatch(queueEntry)) continue;
            break;
        }
        this.logger.debug("Stop SOLR indexer thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processBatch(IndexQueueEntry queueEntry) {
        SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
        int length = 0;
        IndexQueueEntry batchEntry = queueEntry;
        while (batchEntry != null) {
            if (batchEntry == INDEX_QUEUE_ENTRY_STOP) {
                return false;
            }
            IndexOperation operation = batchEntry.operation;
            try {
                this.ecim.initialize(new ExecutionContext());
                if (IndexOperation.INDEX.equals((Object)operation)) {
                    LengthSolrInputDocument solrDocument = this.getSolrDocument(batchEntry.reference);
                    if (solrDocument != null) {
                        solrInstance.add(solrDocument);
                        length += solrDocument.getLength();
                        ++this.batchSize;
                    }
                } else if (IndexOperation.DELETE.equals((Object)operation)) {
                    if (batchEntry.reference == null) {
                        solrInstance.deleteByQuery(batchEntry.deleteQuery);
                    } else {
                        solrInstance.delete(this.solrRefereceResolver.getId(batchEntry.reference));
                    }
                    ++this.batchSize;
                }
            }
            catch (Throwable e) {
                this.logger.error("Failed to process entry [{}]", (Object)batchEntry, (Object)e);
            }
            finally {
                this.execution.removeContext();
            }
            if (this.shouldCommit(length, this.batchSize)) {
                this.commit();
                length = 0;
            }
            batchEntry = (IndexQueueEntry)this.indexQueue.poll();
        }
        if (this.batchSize > 0) {
            this.commit();
        }
        return true;
    }

    private void commit() {
        SolrInstance solrInstance = (SolrInstance)this.solrInstanceProvider.get();
        try {
            solrInstance.commit();
        }
        catch (Exception e) {
            this.logger.error("Failed to commit index changes to the Solr server. Rolling back.", (Throwable)e);
            try {
                solrInstance.rollback();
            }
            catch (Exception ex) {
                this.logger.error("Failed to rollback index changes.", (Throwable)ex);
            }
        }
        this.batchSize = 0;
    }

    private boolean shouldCommit(int length, int size) {
        if (length >= this.configuration.getIndexerBatchMaxLengh()) {
            return true;
        }
        return size >= this.configuration.getIndexerBatchSize();
    }

    private LengthSolrInputDocument getSolrDocument(EntityReference reference) throws SolrIndexerException, IllegalArgumentException, ExecutionContextException {
        SolrMetadataExtractor metadataExtractor = this.getMetadataExtractor(reference.getType());
        if (metadataExtractor != null) {
            return metadataExtractor.getSolrDocument(reference);
        }
        return null;
    }

    private SolrMetadataExtractor getMetadataExtractor(EntityType entityType) {
        SolrMetadataExtractor result = null;
        try {
            result = (SolrMetadataExtractor)this.componentManager.getInstance(SolrMetadataExtractor.class, entityType.name().toLowerCase());
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Unsupported entity type: [{}]", (Object)entityType.toString(), (Object)e);
        }
        return result;
    }

    @Override
    public void index(EntityReference reference, boolean recurse) {
        this.addToQueue(reference, recurse, IndexOperation.INDEX);
    }

    @Override
    public void delete(EntityReference reference, boolean recurse) {
        this.addToQueue(reference, recurse, IndexOperation.DELETE);
    }

    private void addToQueue(EntityReference reference, boolean recurse, IndexOperation operation) {
        if (!this.disposed) {
            try {
                this.resolveQueue.put(new ResolveQueueEntry(reference, recurse, operation));
            }
            catch (InterruptedException e) {
                this.logger.error("Failed to add reference [{}] to Solr indexing queue", (Object)reference, (Object)e);
            }
        }
    }

    @Override
    public int getQueueSize() {
        return this.indexQueue.size() + this.resolveQueue.size() + this.batchSize;
    }

    @Override
    public IndexerJob startIndex(IndexerRequest request) throws SolrIndexerException {
        try {
            return (IndexerJob)this.jobs.execute("solr.indexer", (Request)request);
        }
        catch (JobException e) {
            throw new SolrIndexerException("Failed to start index job", (Exception)((Object)e));
        }
    }

    private class Resolver
    extends AbstractXWikiRunnable {
        private Resolver() {
        }

        public void runInternal() {
            DefaultSolrIndexer.this.logger.debug("Start SOLR resolver thread");
            while (!Thread.interrupted()) {
                ResolveQueueEntry queueEntry;
                try {
                    queueEntry = (ResolveQueueEntry)DefaultSolrIndexer.this.resolveQueue.take();
                }
                catch (InterruptedException e) {
                    DefaultSolrIndexer.this.logger.warn("The SOLR resolve thread has been interrupted", (Throwable)e);
                    queueEntry = RESOLVE_QUEUE_ENTRY_STOP;
                }
                if (queueEntry == RESOLVE_QUEUE_ENTRY_STOP) {
                    DefaultSolrIndexer.this.indexQueue.clear();
                    DefaultSolrIndexer.this.indexQueue.offer(INDEX_QUEUE_ENTRY_STOP);
                    break;
                }
                try {
                    if (queueEntry.operation == IndexOperation.INDEX) {
                        Iterable<EntityReference> references = queueEntry.recurse ? DefaultSolrIndexer.this.solrRefereceResolver.getReferences(queueEntry.reference) : Arrays.asList(queueEntry.reference);
                        for (EntityReference reference : references) {
                            DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(reference, queueEntry.operation));
                        }
                        continue;
                    }
                    if (queueEntry.recurse) {
                        DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(DefaultSolrIndexer.this.solrRefereceResolver.getQuery(queueEntry.reference), queueEntry.operation));
                        continue;
                    }
                    if (queueEntry.reference == null) continue;
                    DefaultSolrIndexer.this.indexQueue.put(new IndexQueueEntry(queueEntry.reference, queueEntry.operation));
                }
                catch (Throwable e) {
                    DefaultSolrIndexer.this.logger.warn("Failed to apply operation [{}] on root reference [{}]", new Object[]{queueEntry.operation, queueEntry.reference, e});
                }
            }
            DefaultSolrIndexer.this.logger.debug("Stop SOLR resolver thread");
        }
    }

    private static class ResolveQueueEntry {
        public EntityReference reference;
        public boolean recurse;
        public IndexOperation operation;

        public ResolveQueueEntry(EntityReference reference, boolean recurse, IndexOperation operation) {
            this.reference = reference;
            this.recurse = recurse;
            this.operation = operation;
        }
    }

    private static class IndexQueueEntry {
        public EntityReference reference;
        public String deleteQuery;
        public IndexOperation operation;

        public IndexQueueEntry(EntityReference indexReference, IndexOperation operation) {
            this.reference = indexReference;
            this.operation = operation;
        }

        public IndexQueueEntry(String deleteQuery, IndexOperation operation) {
            this.deleteQuery = deleteQuery;
            this.operation = operation;
        }

        public String toString() {
            String str;
            switch (this.operation) {
                case INDEX: {
                    str = "INDEX " + this.reference;
                    break;
                }
                case DELETE: {
                    str = "DELETE " + this.deleteQuery;
                    break;
                }
                case STOP: {
                    str = "STOP";
                    break;
                }
                default: {
                    str = "";
                }
            }
            return str;
        }
    }
}

