/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.search.solr.internal.job.AbstractDocumentIterator;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="database")
public class DatabaseDocumentIterator
extends AbstractDocumentIterator<String> {
    private int index;
    private List<Object[]> results = Collections.emptyList();
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    private Iterator<String> wikisIterator;
    private String wiki;
    private int offset;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> explicitEntityReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;
    private Query query;
    private Query countQuery;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;

    @Override
    public boolean hasNext() {
        return this.getResults().size() > this.index;
    }

    @Override
    public Pair<DocumentReference, String> next() {
        Object[] result = this.getResults().get(this.index++);
        String localSpaceReference = (String)result[0];
        String name = (String)result[1];
        String locale = (String)result[2];
        String version = (String)result[3];
        SpaceReference spaceReference = new SpaceReference(this.explicitEntityReferenceResolver.resolve((Object)localSpaceReference, EntityType.SPACE, new Object[]{new WikiReference(this.wiki)}));
        DocumentReference documentReference = new DocumentReference(name, spaceReference);
        if (!StringUtils.isEmpty((CharSequence)locale)) {
            documentReference = new DocumentReference((EntityReference)documentReference, LocaleUtils.toLocale((String)locale));
        }
        return new ImmutablePair((Object)documentReference, (Object)version);
    }

    @Override
    public long size() {
        long size = 0L;
        try {
            this.getQuery();
            for (String wikiName : this.getWikis()) {
                size += ((Long)this.countQuery.setWiki(wikiName).execute().get(0)).longValue();
            }
        }
        catch (QueryException e) {
            throw new IllegalStateException("Failed to count the documents.", e);
        }
        return size;
    }

    private List<Object[]> getResults() {
        if (this.index >= this.results.size()) {
            if (this.wiki == null) {
                this.wiki = this.getNextWiki();
            }
            while (this.wiki != null) {
                this.fetchNextResults();
                if (this.results.size() > 0) break;
                this.wiki = this.getNextWiki();
                this.offset = 0;
            }
            this.index = 0;
        }
        return this.results;
    }

    private void fetchNextResults() {
        try {
            this.results = this.getQuery().setWiki(this.wiki).setOffset(this.offset).execute();
            this.offset += 100;
        }
        catch (QueryException e) {
            throw new IllegalStateException("Failed to query the database.", e);
        }
    }

    private Query getQuery() throws QueryException {
        if (this.query == null) {
            String select = "select doc.space, doc.name, doc.language, doc.version from XWikiDocument doc";
            String orderBy = " order by doc.space, doc.name, doc.language";
            EntityReference spaceReference = null;
            EntityReference documentReference = null;
            if (this.rootReference != null) {
                spaceReference = this.rootReference.extractReference(EntityType.SPACE);
                documentReference = this.rootReference.extractReference(EntityType.DOCUMENT);
            }
            String whereClause = "";
            if (spaceReference != null) {
                whereClause = whereClause + " where doc.space = :space";
                if (documentReference != null) {
                    whereClause = whereClause + " and doc.name = :name";
                }
            }
            this.query = this.queryManager.createQuery(select + whereClause + orderBy, "hql").setLimit(100);
            this.countQuery = this.queryManager.createQuery(whereClause, "hql").addFilter(this.countFilter);
            if (spaceReference != null) {
                this.query.bindValue("space", this.localEntityReferenceSerializer.serialize(spaceReference, new Object[0]));
                if (documentReference != null) {
                    this.query.bindValue("name", (Object)documentReference.getName());
                }
            }
            for (Map.Entry parameter : this.query.getNamedParameters().entrySet()) {
                this.countQuery.bindValue((String)parameter.getKey(), parameter.getValue());
            }
        }
        return this.query;
    }

    private String getNextWiki() {
        if (this.wikisIterator == null) {
            List<String> wikis = this.getWikis();
            Collections.sort(wikis);
            this.wikisIterator = wikis.iterator();
        }
        return this.wikisIterator.hasNext() ? this.wikisIterator.next() : null;
    }

    private List<String> getWikis() {
        if (this.rootReference == null) {
            ArrayList<String> wikis;
            try {
                wikis = new ArrayList<String>(this.wikiDescriptorManager.getAllIds());
            }
            catch (WikiManagerException e) {
                throw new IllegalStateException("Failed to get the list of available wikis.", e);
            }
            return wikis;
        }
        return Arrays.asList(this.rootReference.extractReference(EntityType.WIKI).getName());
    }
}

