/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import java.util.Comparator;
import java.util.Iterator;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class DocumentReferenceComparator
implements Comparator<DocumentReference> {
    @Override
    public int compare(DocumentReference alice, DocumentReference bob) {
        Iterator aliceIterator = alice.getReversedReferenceChain().iterator();
        Iterator bobIterator = bob.getReversedReferenceChain().iterator();
        while (aliceIterator.hasNext() && bobIterator.hasNext()) {
            int diff = ((EntityReference)aliceIterator.next()).getName().compareTo(((EntityReference)bobIterator.next()).getName());
            if (diff == 0) continue;
            return diff;
        }
        if (aliceIterator.hasNext()) {
            return 1;
        }
        if (bobIterator.hasNext()) {
            return -1;
        }
        String aliceLocale = alice.getLocale() != null ? alice.getLocale().toString() : "";
        String bobLocale = bob.getLocale() != null ? bob.getLocale().toString() : "";
        return aliceLocale.compareTo(bobLocale);
    }
}

