/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Singleton
public class DefaultSolrConfiguration
implements SolrConfiguration {
    public static final String DEFAULT_SOLR_TYPE = "embedded";
    public static final List<String> DEFAULT_OPTIMIZABLE_LANGUAGES = Arrays.asList("ar", "bg", "ca", "cz", "da", "de", "en", "el", "es", "eu", "fa", "fi", "fr", "ga", "gl", "hi", "hu", "hy", "id", "it", "ja", "lv", "nl", "no", "pt", "ro", "ru", "sv", "th", "tr");
    public static final List<String> DEFAULT_OPTIMIZED_LANGUAGES = DEFAULT_OPTIMIZABLE_LANGUAGES;
    public static final List<String> DEFAULT_MULTILINGUAL_FIELDS = Arrays.asList("title", "doccontent", "comment", "objcontent", "propertyvalue", "attcontent");
    public static final String CLASSPATH_LOCATION_PREFIX = "/solr/%s";
    public static final String CONF_DIRECTORY = "conf";
    public static final String CONF_FILE_LOCATION_PATTERN = "/%s/%s/%s";
    public static final String[] HOME_DIRECTORY_FILE_NAMES = new String[]{"solr.xml"};
    public static final String[] CONF_DIRECTORY_FILE_NAMES = new String[]{"solrconfig.xml", "schema.xml", "elevate.xml", "protwords.txt", "stopwords.txt", "synonyms.txt"};
    public static final String[] LANGUAGE_RESOURCE_FILE_NAME_PREFIXES = new String[]{"contractions", "hyphenations", "stemdict", "stoptags", "stopwords", "synonyms", "userdict"};
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;

    @Override
    public String getServerType() {
        return (String)this.configuration.getProperty("solr.type", (Object)DEFAULT_SOLR_TYPE);
    }

    @Override
    public <T> T getInstanceConfiguration(String instanceType, String propertyName, T defaultValue) {
        String actualPropertyName = String.format("%s.%s.%s", "solr", instanceType, propertyName);
        return (T)this.configuration.getProperty(actualPropertyName, defaultValue);
    }

    @Override
    public List<String> getOptimizableLanguages() {
        return (List)this.configuration.getProperty("solr.multilingual.availableLanguages", DEFAULT_OPTIMIZABLE_LANGUAGES);
    }

    @Override
    public List<String> getOptimizedLanguages() {
        return (List)this.configuration.getProperty("solr.multilingual.activeLanguages", DEFAULT_OPTIMIZED_LANGUAGES);
    }

    @Override
    public List<String> getMultilingualFields() {
        return (List)this.configuration.getProperty("solr.multilingual.fields", DEFAULT_MULTILINGUAL_FIELDS);
    }

    @Override
    public Map<String, URL> getHomeDirectoryConfiguration() {
        HashMap<String, URL> result = new HashMap<String, URL>();
        for (String file : HOME_DIRECTORY_FILE_NAMES) {
            result.put(file, this.getClass().getResource(String.format(CLASSPATH_LOCATION_PREFIX, file)));
        }
        for (String file : CONF_DIRECTORY_FILE_NAMES) {
            String fileName = String.format("%s/%s", CONF_DIRECTORY, file);
            String classPathLocation = String.format(CLASSPATH_LOCATION_PREFIX, fileName);
            URL classPathURL = this.getClass().getResource(classPathLocation);
            result.put(fileName, classPathURL);
        }
        for (String language : this.getOptimizableLanguages()) {
            for (String languageFileName : LANGUAGE_RESOURCE_FILE_NAME_PREFIXES) {
                String fileName = String.format("%s/lang/%s_%s.txt", CONF_DIRECTORY, languageFileName, language);
                String classPathLocation = String.format(CLASSPATH_LOCATION_PREFIX, fileName);
                URL classPathURL = this.getClass().getResource(classPathLocation);
                try {
                    URLConnection testConnection = classPathURL.openConnection();
                    testConnection.connect();
                    result.put(fileName, classPathURL);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

