/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@Singleton
public class SolrInstanceProvider
implements Provider<SolrInstance> {
    @Inject
    private Logger logger;
    @Inject
    private SolrConfiguration configuration;
    @Inject
    private ComponentManager componentManager;

    public SolrInstance get() {
        String type = this.configuration.getServerType();
        SolrInstance newInstance = null;
        try {
            newInstance = (SolrInstance)this.componentManager.getInstance(SolrInstance.class, type);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup Solr instance", (Throwable)e);
        }
        return newInstance;
    }
}

