/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.metadata.SolrMetadataExtractor;

public abstract class AbstractSolrMetadataExtractor
implements SolrMetadataExtractor {
    private static final String OBJCONTENT_FORMAT = "%s:%s";
    @Inject
    protected Logger logger;
    @Inject
    protected Execution execution;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    protected EntityReferenceSerializer<String> localSerializer;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;

    @Override
    public String getId(EntityReference reference) throws SolrIndexException {
        String result = (String)this.serializer.serialize(reference, new Object[0]);
        return result;
    }

    protected XWikiContext getXWikiContext() {
        ExecutionContext executionContext = this.execution.getContext();
        XWikiContext context = (XWikiContext)executionContext.getProperty("xwikicontext");
        return context;
    }

    protected XWikiDocument getDocument(DocumentReference documentReference) throws XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = context.getWiki().getDocument(documentReference, context);
        return document;
    }

    protected XWikiDocument getTranslatedDocument(DocumentReference documentReference) throws SolrIndexException {
        try {
            XWikiDocument document = this.getDocument(documentReference);
            String doclang = "";
            Locale locale = documentReference.getLocale();
            if (locale != null && !StringUtils.isEmpty((CharSequence)locale.toString())) {
                doclang = documentReference.getLocale().toString();
            }
            XWikiDocument translatedDocument = document.getTranslatedDocument(doclang, this.getXWikiContext());
            return translatedDocument;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to get translated document for '%s'", this.serializer.serialize((EntityReference)documentReference, new Object[0])), e);
        }
    }

    protected void addDocumentFields(DocumentReference documentReference, SolrInputDocument solrDocument) throws Exception {
        solrDocument.addField("wiki", (Object)documentReference.getWikiReference().getName());
        solrDocument.addField("space", (Object)documentReference.getLastSpaceReference().getName());
        solrDocument.addField("name", (Object)documentReference.getName());
        String language = this.getLanguage(documentReference);
        solrDocument.addField("lang", (Object)language);
        XWikiDocument document = this.getDocument(documentReference);
        solrDocument.addField("hidden", (Object)document.isHidden());
    }

    protected String getLanguage(DocumentReference documentReference) throws SolrIndexException {
        String language = null;
        try {
            language = documentReference.getLocale() != null && !StringUtils.isEmpty((CharSequence)documentReference.getLocale().getDisplayLanguage()) ? documentReference.getLocale().toString() : (!StringUtils.isEmpty((CharSequence)this.documentAccessBridge.getDocument(documentReference).getRealLanguage()) ? this.documentAccessBridge.getDocument(documentReference).getRealLanguage() : "en");
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Exception while fetching the language of the document '%s'", this.serializer.serialize((EntityReference)documentReference, new Object[0])), e);
        }
        return language;
    }

    protected void addObjectContent(SolrInputDocument solrDocument, BaseObject object, String language) {
        if (object == null) {
            return;
        }
        String fieldName = String.format("%s_%s", "objcontent", language);
        XWikiContext context = this.getXWikiContext();
        BaseClass xClass = object.getXClass(context);
        for (Object field : object.getFieldList()) {
            PropertyClass propertyClass;
            BaseProperty property = (BaseProperty)field;
            Object propertyValue = property.getValue();
            if (propertyValue == null || (propertyClass = (PropertyClass)xClass.get(property.getName())) instanceof PasswordClass) continue;
            if (propertyValue instanceof List) {
                List propertyListValues = (List)propertyValue;
                for (Object propertyListValue : propertyListValues) {
                    solrDocument.addField(fieldName, (Object)String.format(OBJCONTENT_FORMAT, property.getName(), propertyListValue));
                }
                continue;
            }
            solrDocument.addField(fieldName, (Object)String.format(OBJCONTENT_FORMAT, property.getName(), propertyValue));
        }
    }
}

