/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.doc.XWikiDocument;
import java.io.InputStream;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;

@Component
@Named(value="attachment")
public class AttachmentSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Override
    public SolrInputDocument getSolrDocument(EntityReference entityReference) throws SolrIndexException, IllegalArgumentException {
        AttachmentReference attachmentReference = new AttachmentReference(entityReference);
        try {
            SolrInputDocument solrDocument = new SolrInputDocument();
            DocumentReference documentReference = attachmentReference.getDocumentReference();
            solrDocument.addField("id", (Object)this.getId((EntityReference)attachmentReference));
            this.addDocumentFields(documentReference, solrDocument);
            solrDocument.addField("type", (Object)attachmentReference.getType().name());
            solrDocument.addField("filename", (Object)attachmentReference.getName());
            solrDocument.addField("mimetype", (Object)this.getMimeType(attachmentReference));
            this.addLanguageAndContentFields(documentReference, solrDocument, attachmentReference);
            return solrDocument;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to get Solr document for '%s'", this.serializer.serialize((EntityReference)attachmentReference, new Object[0])), e);
        }
    }

    protected void addLanguageAndContentFields(DocumentReference documentReference, SolrInputDocument solrDocument, AttachmentReference attachmentReference) throws Exception {
        String originalDocumentLanguage;
        XWikiDocument originalDocument = this.getDocument(documentReference);
        List documentLanguages = originalDocument.getTranslationList(this.getXWikiContext());
        if (!documentLanguages.contains(originalDocumentLanguage = this.getLanguage(documentReference))) {
            documentLanguages.add(originalDocumentLanguage);
        }
        String attachmentTextContent = this.getContentAsText(attachmentReference);
        for (String documentLanguage : documentLanguages) {
            if (!documentLanguage.equals(originalDocumentLanguage)) {
                solrDocument.addField("lang", (Object)documentLanguage);
            }
            solrDocument.addField(String.format("%s_%s", "attcontent", documentLanguage), (Object)attachmentTextContent);
        }
        solrDocument.addField(String.format("%s_%s", "attcontent", "ml"), (Object)attachmentTextContent);
    }

    protected String getContentAsText(AttachmentReference attachment) throws SolrIndexException {
        try {
            Tika tika = new Tika();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", attachment.getName());
            InputStream in = this.documentAccessBridge.getAttachmentContent(attachment);
            String result = StringUtils.lowerCase((String)tika.parseToString(in, metadata));
            return result;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to retrieve attachment content for '%s'", this.serializer.serialize((EntityReference)attachment, new Object[0])), e);
        }
    }

    protected String getMimeType(AttachmentReference reference) {
        String mimetype = this.getXWikiContext().getEngineContext().getMimeType(reference.getName().toLowerCase());
        if (mimetype != null) {
            return mimetype;
        }
        return "application/octet-stream";
    }
}

