/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.job;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.job.AbstractDocumentIterator;
import org.xwiki.search.solr.internal.job.DocumentIterator;
import org.xwiki.search.solr.internal.job.DocumentReferenceComparator;

public class DiffDocumentIterator<T>
extends AbstractDocumentIterator<Action> {
    private final DocumentIterator<T> previous;
    private final DocumentIterator<T> next;
    private final DocumentReferenceComparator documentReferenceComparator = new DocumentReferenceComparator();
    private Pair<DocumentReference, T> previousEntry;
    private Pair<DocumentReference, T> nextEntry;
    private int diff;

    public DiffDocumentIterator(DocumentIterator<T> previous, DocumentIterator<T> next) {
        this.previous = previous;
        this.next = next;
    }

    @Override
    public void setRootReference(EntityReference rootReference) {
        this.previous.setRootReference(rootReference);
        this.next.setRootReference(rootReference);
    }

    @Override
    public boolean hasNext() {
        return this.previous.hasNext() || this.next.hasNext();
    }

    @Override
    public Pair<DocumentReference, Action> next() {
        Action action;
        DocumentReference documentReference;
        if (this.next.hasNext() && this.previous.hasNext()) {
            if (this.diff >= 0) {
                this.nextEntry = (Pair)this.next.next();
            }
            if (this.diff <= 0) {
                this.previousEntry = (Pair)this.previous.next();
            }
            this.diff = this.documentReferenceComparator.compare((DocumentReference)this.previousEntry.getKey(), (DocumentReference)this.nextEntry.getKey());
            if (this.diff == 0) {
                documentReference = (DocumentReference)this.nextEntry.getKey();
                action = this.nextEntry.getValue().equals(this.previousEntry.getValue()) ? Action.SKIP : Action.UPDATE;
            } else if (this.diff > 0) {
                documentReference = (DocumentReference)this.nextEntry.getKey();
                action = Action.ADD;
            } else {
                documentReference = (DocumentReference)this.previousEntry.getKey();
                action = Action.DELETE;
            }
        } else if (this.next.hasNext()) {
            documentReference = (DocumentReference)((Pair)this.next.next()).getKey();
            action = Action.ADD;
        } else {
            documentReference = (DocumentReference)((Pair)this.previous.next()).getKey();
            action = Action.DELETE;
        }
        return new ImmutablePair((Object)documentReference, (Object)action);
    }

    @Override
    public long size() {
        return Math.max(this.previous.size(), this.next.size());
    }

    public static enum Action {
        SKIP,
        ADD,
        DELETE,
        UPDATE;

    }
}

