/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.BooleanClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.api.FieldUtils;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.metadata.LengthSolrInputDocument;
import org.xwiki.search.solr.internal.metadata.SolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.TypedValue;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

public abstract class AbstractSolrMetadataExtractor
implements SolrMetadataExtractor {
    private static final String OBJCONTENT_FORMAT = "%s : %s";
    protected static final int SHORT_TEXT_LIMIT = 255;
    @Inject
    protected Logger logger;
    @Inject
    protected Execution execution;
    @Inject
    @Named(value="local")
    protected EntityReferenceSerializer<String> localSerializer;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected ComponentManager componentManager;

    @Override
    public LengthSolrInputDocument getSolrDocument(EntityReference entityReference) throws SolrIndexerException, IllegalArgumentException {
        try {
            LengthSolrInputDocument solrDocument = new LengthSolrInputDocument();
            solrDocument.setField("id", this.getResolver(entityReference).getId(entityReference));
            if (!this.setDocumentFields(new DocumentReference(entityReference.extractReference(EntityType.DOCUMENT)), solrDocument)) {
                return null;
            }
            solrDocument.setField("type", entityReference.getType().name());
            if (!this.setFieldsInternal(solrDocument, entityReference)) {
                return null;
            }
            return solrDocument;
        }
        catch (Exception e) {
            String message = String.format("Failed to get input Solr document for entity '%s'", entityReference);
            throw new SolrIndexerException(message, e);
        }
    }

    protected abstract boolean setFieldsInternal(LengthSolrInputDocument var1, EntityReference var2) throws Exception;

    protected SolrReferenceResolver getResolver(EntityReference entityReference) throws SolrIndexerException {
        try {
            return (SolrReferenceResolver)this.componentManager.getInstance(SolrReferenceResolver.class, entityReference.getType().getLowerCase());
        }
        catch (ComponentLookupException e) {
            throw new SolrIndexerException("Faile to find solr reference resolver for type reference [" + entityReference + "]");
        }
    }

    protected XWikiDocument getDocument(DocumentReference documentReference) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return document;
    }

    protected XWikiDocument getTranslatedDocument(DocumentReference documentReference) throws SolrIndexerException {
        try {
            XWikiDocument document = this.getDocument(documentReference);
            Locale locale = documentReference.getLocale();
            if (locale == null || locale.equals(Locale.ROOT)) {
                return document;
            }
            XWikiDocument translatedDocument = document.getTranslatedDocument(locale, (XWikiContext)this.xcontextProvider.get());
            if (translatedDocument.getRealLocale().equals(locale)) {
                return translatedDocument;
            }
        }
        catch (Exception e) {
            throw new SolrIndexerException(String.format("Failed to get translated document for '%s'", documentReference), e);
        }
        return null;
    }

    protected boolean setDocumentFields(DocumentReference documentReference, SolrInputDocument solrDocument) throws Exception {
        XWikiDocument document = this.getDocument(documentReference);
        if (document.isNew()) {
            return false;
        }
        solrDocument.setField("hidden", (Object)document.isHidden());
        solrDocument.setField("wiki", (Object)documentReference.getWikiReference().getName());
        solrDocument.setField("space", (Object)documentReference.getLastSpaceReference().getName());
        solrDocument.setField("name", (Object)documentReference.getName());
        Locale locale = this.getLocale(documentReference);
        solrDocument.setField("locale", (Object)locale.toString());
        solrDocument.setField("language", (Object)locale.getLanguage());
        return true;
    }

    protected Set<Locale> getLocales(DocumentReference documentReference, Locale entityLocale) throws XWikiException, SolrIndexerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return this.getLocales(xcontext.getWiki().getDocument(documentReference, xcontext), entityLocale);
    }

    protected Set<Locale> getLocales(XWikiDocument xdocument, Locale entityLocale) throws XWikiException, SolrIndexerException {
        String entityLocaleString;
        HashSet<Locale> locales = new HashSet<Locale>();
        String string = entityLocaleString = entityLocale != null ? entityLocale.toString() : null;
        if (entityLocale != null) {
            locales.add(entityLocale);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        List documentLocales = xdocument.getTranslationLocales((XWikiContext)this.xcontextProvider.get());
        if (entityLocale == null) {
            for (Locale locale : documentLocales) {
                locales.add(locale);
            }
        }
        List availableLocales = xcontext.getWiki().getAvailableLocales(xcontext);
        for (Locale locale : availableLocales) {
            if (documentLocales.contains(locale) || entityLocale != null && !locale.toString().startsWith(entityLocaleString)) continue;
            locales.add(locale);
        }
        locales.add(this.getLocale(xdocument.getDocumentReference()));
        return locales;
    }

    protected void addLocales(XWikiDocument xdocument, Locale entityLocale, SolrInputDocument solrDocument) throws SolrIndexerException, XWikiException {
        Set<Locale> locales = this.getLocales(xdocument, entityLocale);
        for (Locale childLocale : locales) {
            solrDocument.addField("locales", (Object)childLocale.toString());
        }
    }

    protected Locale getLocale(DocumentReference documentReference) throws SolrIndexerException {
        Locale locale = null;
        try {
            if (documentReference.getLocale() != null && !documentReference.getLocale().equals(Locale.ROOT)) {
                locale = documentReference.getLocale();
            } else {
                XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
                locale = xcontext.getWiki().getDocument(documentReference, xcontext).getRealLocale();
            }
        }
        catch (Exception e) {
            throw new SolrIndexerException(String.format("Exception while fetching the locale of the document '%s'", documentReference), e);
        }
        return locale;
    }

    protected void setObjectContent(SolrInputDocument solrDocument, BaseObject object, Locale locale) {
        if (object == null) {
            return;
        }
        BaseClass xClass = object.getXClass((XWikiContext)this.xcontextProvider.get());
        for (Object field : object.getFieldList()) {
            BaseProperty property = (BaseProperty)field;
            if (property.getValue() == null) continue;
            PropertyClass propertyClass = (PropertyClass)xClass.get(property.getName());
            this.setPropertyValue(solrDocument, (BaseProperty<EntityReference>)property, propertyClass, locale);
        }
    }

    private void setPropertyValue(SolrInputDocument solrDocument, BaseProperty<EntityReference> property, PropertyClass propertyClass, Locale locale) {
        Object propertyValue = property.getValue();
        if (propertyClass instanceof StaticListClass) {
            this.setStaticListPropertyValue(solrDocument, property, (StaticListClass)propertyClass, locale);
        } else if (propertyClass instanceof TextAreaClass || propertyClass != null && "String".equals(propertyClass.getClassType()) || String.valueOf(propertyValue).length() > 255) {
            this.setPropertyValue(solrDocument, property, new TypedValue(propertyValue, TypedValue.TEXT), locale);
        } else if (propertyValue instanceof Collection) {
            for (Object value : (Collection)propertyValue) {
                if (value == null) continue;
                this.setPropertyValue(solrDocument, property, new TypedValue(value), locale);
            }
        } else if (propertyValue instanceof Integer && propertyClass instanceof BooleanClass) {
            Boolean booleanValue = (Integer)propertyValue != 0;
            this.setPropertyValue(solrDocument, property, new TypedValue(booleanValue), locale);
        } else if (!(propertyClass instanceof PasswordClass)) {
            this.setPropertyValue(solrDocument, property, new TypedValue(propertyValue), locale);
        }
    }

    private void setStaticListPropertyValue(SolrInputDocument solrDocument, BaseProperty<EntityReference> property, StaticListClass propertyClass, Locale locale) {
        Map knownValues = propertyClass.getMap((XWikiContext)this.xcontextProvider.get());
        Object propertyValue = property.getValue();
        List<Object> rawValues = propertyValue instanceof List ? (List<Object>)propertyValue : Arrays.asList(propertyValue);
        for (Object e : rawValues) {
            if (e == null) continue;
            this.setPropertyValue(solrDocument, property, new TypedValue(e), locale);
            ListItem valueInfo = (ListItem)knownValues.get(e);
            if (valueInfo == null || valueInfo.getValue() == null || valueInfo.getValue().equals(e)) continue;
            this.setPropertyValue(solrDocument, property, new TypedValue(valueInfo.getValue(), TypedValue.TEXT), locale);
        }
    }

    protected void setPropertyValue(SolrInputDocument solrDocument, BaseProperty<EntityReference> property, TypedValue typedValue, Locale locale) {
        String fieldName = FieldUtils.getFieldName("objcontent", locale);
        solrDocument.addField(fieldName, (Object)String.format(OBJCONTENT_FORMAT, property.getName(), typedValue.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContentAsText(XWikiAttachment attachment) {
        String string;
        Tika tika = new Tika();
        Metadata metadata = new Metadata();
        metadata.set("resourceName", attachment.getFilename());
        InputStream in = attachment.getContentInputStream((XWikiContext)this.xcontextProvider.get());
        try {
            string = tika.parseToString(in, metadata);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                this.logger.error("Failed to retrieve the content of attachment [{}]", (Object)attachment.getReference(), (Object)e);
                return null;
            }
        }
        in.close();
        return string;
    }
}

