/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.api.FieldUtils;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.LengthSolrInputDocument;

@Component
@Named(value="attachment")
@Singleton
public class AttachmentSolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public boolean setFieldsInternal(LengthSolrInputDocument solrDocument, EntityReference entityReference) throws Exception {
        AttachmentReference attachmentReference = new AttachmentReference(entityReference);
        XWikiDocument document = this.getDocument(attachmentReference.getDocumentReference());
        XWikiAttachment attachment = document.getAttachment(attachmentReference.getName());
        if (attachment == null) {
            return false;
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        solrDocument.setField("filename", attachment.getFilename());
        solrDocument.setField("filename_sort", attachment.getFilename());
        solrDocument.setField("mimetype", attachment.getMimeType(xcontext));
        solrDocument.setField("attdate", attachment.getDate());
        solrDocument.setField("attdate_sort", attachment.getDate());
        solrDocument.setField("attsize", attachment.getFilesize());
        solrDocument.setField("attsize_sort", attachment.getFilesize());
        solrDocument.setField("attversion", attachment.getVersion());
        DocumentReference authorReference = this.documentReferenceResolver.resolve((Object)attachment.getAuthor(), new Object[]{attachment.getReference()});
        String authorStringReference = (String)this.entityReferenceSerializer.serialize((EntityReference)authorReference, new Object[0]);
        solrDocument.setField("attauthor", authorStringReference);
        try {
            String authorDisplayName = xcontext.getWiki().getUserName(authorStringReference, null, false, xcontext);
            solrDocument.setField("attauthor_display", authorDisplayName);
            solrDocument.setField("attauthor_display_sort", authorDisplayName);
        }
        catch (Exception e) {
            this.logger.error("Failed to get author display name for attachment [{}]", (Object)attachment.getReference(), (Object)e);
        }
        this.setLocaleAndContentFields(attachment, solrDocument);
        return true;
    }

    protected void setLocaleAndContentFields(XWikiAttachment attachment, SolrInputDocument solrDocument) throws Exception {
        String attachmentTextContent = this.getContentAsText(attachment);
        for (Locale documentLocale : this.getLocales(attachment.getDoc(), null)) {
            solrDocument.addField("locales", (Object)documentLocale.toString());
            solrDocument.setField(FieldUtils.getFieldName("attcontent", documentLocale), (Object)attachmentTextContent);
        }
        solrDocument.setField(FieldUtils.getFieldName("attcontent", null), (Object)attachmentTextContent);
    }
}

