/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.classes.PasswordClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.AbstractSolrReferenceResolver;

@Component
@Named(value="object_property")
@Singleton
public class ObjectPropertySolrReferenceResolver
extends AbstractSolrReferenceResolver {
    public List<EntityReference> getReferences(EntityReference objectPropertyReference) throws SolrIndexerException {
        XWikiDocument xclassDocument;
        BaseObjectReference objectReference = new BaseObjectReference(objectPropertyReference.getParent());
        DocumentReference classReference = objectReference.getXClassReference();
        try {
            xclassDocument = this.getDocument(classReference);
        }
        catch (Exception e) {
            throw new SolrIndexerException("Failed to get document for xclass [" + classReference + "]", e);
        }
        if (!(xclassDocument.getXClass().get(objectPropertyReference.getName()) instanceof PasswordClass)) {
            return Arrays.asList(objectPropertyReference);
        }
        return Collections.EMPTY_LIST;
    }
}

